/*

 RemoteSessionExecutorsManager.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.exigrid.execute;

import java.rmi.ConnectException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.Logger;

import net.sqs2.exigrid.session.Session;
import net.sqs2.exigrid.session.SessionService;

import org.apache.commons.collections15.map.LRUMap;

public class RemoteSessionManager {

	private Map<String,SessionExecutor> connectedExecutorMap;
	private Session sessionManager;
	private int maximumNumberOfConnections;

	public RemoteSessionManager(Session sessionManager, int maximumNumberOfConnections){
		this.sessionManager = sessionManager;
		this.maximumNumberOfConnections = maximumNumberOfConnections;
		this.connectedExecutorMap = new LRUMap<String,SessionExecutor>(this.maximumNumberOfConnections){
			private static final long serialVersionUID = 0L;
			protected boolean removeLRU(LinkEntry<String,SessionExecutor> entry) {
				// release resources held by entry
				((SessionExecutor)entry.getValue()).stop();
				return true;  // actually delete entry
			}
		};
	}

	public synchronized void connect(long key, String uri){
		SessionExecutor sessionExecutor = this.connectedExecutorMap.get(uri);
		if(sessionExecutor == null || sessionExecutor.isConnected() == false){
			sessionExecutor = createConnectedSessionExecutor(key, uri);
			if(sessionExecutor != null){
				this.connectedExecutorMap.put(uri, sessionExecutor);
			}else{
				this.connectedExecutorMap.remove(uri);
			}
		}else{
			//Logger.getLogger("remoteSessionManager").info("already connected:"+key);
		}
	}

	public void shutdown(){
		for(SessionExecutor sessionExecutor : this.connectedExecutorMap.values()){
			if(sessionExecutor != null){
				sessionExecutor.shutdown();
			}
		}
	}

	private SessionExecutor createConnectedSessionExecutor(long key, String uri){
		try{
			Logger.getLogger("executor").info("RemoteSessionService.URI="+uri);
			SessionService sessionService = (SessionService)Naming.lookup(uri); // connect to remote SessionService
			long result = sessionService.ping(key); // authentication
			Logger.getLogger("executor").info("Hello="+result);
			SessionExecutor executor = new SessionExecutor(key, this.sessionManager, sessionService);
			executor.start(); // set connected
			return executor;
		}catch(ConnectException ex){
			Logger.getLogger("executor").severe("ConnectException:"+ex.getMessage());
		}catch(RemoteException ex){
			Logger.getLogger("executor").severe("RemoteException:"+ex.getMessage());
		}catch(MalformedURLException ex){
			Logger.getLogger("executor").severe("MalformedException:"+ex.getMessage());
		}catch(NotBoundException ex){
			Logger.getLogger("executor").severe("NotBoundException:"+ex.getMessage());
		}
		return null;
	}
}
