<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns="http://relaxng.org/ns/structure/1.0"
xmlns:xalan="http://xml.apache.org/xalan"
version="1.0">

<xsl:template match="/">
<grammar xmlns="http://relaxng.org/ns/structure/1.0"
 datatypeLibrary="http://www.w3.org/2001/XMLSchema-datatypes">
<start>
<ref name="root"/>
</start>
<define name="root">
<xsl:apply-templates select="@*|node()"/>
</define>
</grammar>
</xsl:template>

<xsl:template match="@*" mode="text">
<xsl:call-template name="attribute"/>
</xsl:template>
<xsl:template match="@*">
<xsl:call-template name="attribute"/>
</xsl:template>
<xsl:template name="attribute">
<attribute name="{local-name()}" ns="{namespace-uri()}">
<value><xsl:value-of select="."/></value>
</attribute>
</xsl:template>

<xsl:template match="node()" mode="text">
<xsl:call-template name="node"/>
</xsl:template>
<xsl:template match="node()">
<xsl:call-template name="node"/>
</xsl:template>
<xsl:template name="node">
<xsl:variable name="ns"><xsl:choose>
<xsl:when test="namespace-uri() = ''"><xsl:value-of select="/*/attribute::xmlns"/></xsl:when>
<xsl:otherwise><xsl:value-of select="namespace-uri()"/></xsl:otherwise>
</xsl:choose></xsl:variable>
<element name="{local-name()}" ns="{$ns}">
<xsl:choose>
<xsl:when test="0 = count(child::*) and 0 = count(child::text())">
<xsl:apply-templates select="@*"/>
<empty/>
</xsl:when>
<!--
  Jing/RelaxNG では mixed content の data pattern 部分の検証ができない．
  参照→ http://www.oasis-open.org/committees/relax-ng/tutorial.html#IDA5UYR
  これは，本スクリプト内では string pattern の検証ができないという
  問題として発現する．
  そこで，ad-hocな対応として， string pattern のノードを text pattern で
  置き換えることにする．
 -->
<xsl:when test="0 &lt; count(child::*) and 0 &lt; count(child::text())">
 <xsl:apply-templates select="@*|node()|text()" mode="text"/>
</xsl:when>
<xsl:otherwise>
<xsl:apply-templates select="@*|node()|text()"/>
</xsl:otherwise>
</xsl:choose>
</element>
</xsl:template>

<xsl:template match="text()">
<value><xsl:value-of select="."/></value>
</xsl:template>

<xsl:template match="text()" mode="text">
<text/><xsl:comment><xsl:value-of select="."/></xsl:comment>
</xsl:template>

</xsl:stylesheet>

