<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:reader="http://sqs.cmr.sfc.keio.ac.jp/2004/reader"
xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
xmlns:o="urn:schemas-microsoft-com:office:office"
xmlns:x="urn:schemas-microsoft-com:office:excel"
xmlns:html="http://www.w3.org/TR/REC-html40"
xmlns:x2="http://schemas.microsoft.com/office/excel/2003/xml"
version="1.0">
<!-- xmlns="urn:schemas-microsoft-com:office:spreadsheet" -->

<xsl:template match="text()">
</xsl:template>
<!--
<xsl:template match="/">
<reader:samples>
  <xsl:for-each select="//reader:page">
    <xsl:sort select="@sampleID" data-type="number"/>
    <xsl:sort select="@number" data-type="number"/>
    <xsl:variable name="sampleID"><xsl:value-of select="@sampleID"/></xsl:variable>
    <xsl:variable name="number"><xsl:value-of select="@number"/></xsl:variable>

    <xsl:if test="count(preceding-sibling::*[@sampleID=$sampleID]) = 0">
<xsl:text disable-output-escaping="yes">
&lt;reader:sample sampleID="</xsl:text><xsl:value-of select="$sampleID"/>
<xsl:text disable-output-escaping="yes">"&gt;</xsl:text>
    </xsl:if>

    <reader:page number="{$number}">
	<xsl:copy-of select="*"/>
    </reader:page>

    <xsl:if test="count(following-sibling::*[@sampleID=$sampleID]) = 0">
<xsl:text disable-output-escaping="yes">
&lt;/reader:sample&gt;
</xsl:text>
    </xsl:if>

    </xsl:for-each>

</reader:samples>
</xsl:template>
-->

<xsl:template match="/">



<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:o="urn:schemas-microsoft-com:office:office"
 xmlns:x="urn:schemas-microsoft-com:office:excel"
 xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:html="http://www.w3.org/TR/REC-html40">
 <DocumentProperties xmlns="urn:schemas-microsoft-com:office:office">
  <Author></Author>
  <LastAuthor></LastAuthor>
  <Created>2004-07-17T06:12:54Z</Created>
  <Company></Company>
  <Version>10.2625</Version>
 </DocumentProperties>
 <OfficeDocumentSettings xmlns="urn:schemas-microsoft-com:office:office">
  <AllowPNG/>
  <DownloadComponents/>
<!--  <LocationOfComponents HRef="file:///D:\"/>-->
 </OfficeDocumentSettings>
 <ExcelWorkbook xmlns="urn:schemas-microsoft-com:office:excel">
  <WindowHeight>7650</WindowHeight>
  <WindowWidth>9540</WindowWidth>
  <WindowTopX>120</WindowTopX>
  <WindowTopY>30</WindowTopY>
  <ActiveSheet>1</ActiveSheet>
  <ProtectStructure>False</ProtectStructure>
  <ProtectWindows>False</ProtectWindows>
 </ExcelWorkbook>
 <Styles>
  <Style ss:ID="Default" ss:Name="Normal">
   <Alignment ss:Vertical="Center"/>
   <Borders/>
   <Font ss:FontName="ＭＳ Ｐゴシック" x:CharSet="128" x:Family="Modern" ss:Size="11"/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
 </Styles>
 <Worksheet ss:Name="Sheet1">

<xsl:variable name="cols" select="count(//reader:page[@sampleID='1']) + 1"/>
<xsl:variable name="rows" select="floor(count(//reader:page) div count(//reader:page[@sampleID='1'])) + 1"/>

<Table ss:DefaultColumnWidth="54" 
ss:ExpandedColumnCount="{$cols}" ss:ExpandedRowCount="{$rows}" x:FullColumns="1" x:FullRows="1" 
ss:DefaultRowHeight="13.5">

  <xsl:for-each select="//reader:page[@sampleID='1']">
    <ss:Column/>
  </xsl:for-each>

  <ss:Row ss:AutoFitHeight="0">
  <ss:Cell><ss:Data ss:Type="String"></ss:Data></ss:Cell>
  <xsl:for-each select="//reader:page[@sampleID='1']">
    <ss:Cell><ss:Data ss:Type="Number"><xsl:value-of select="position()"/></ss:Data></ss:Cell>
  </xsl:for-each>
  </ss:Row>

  <xsl:for-each select="//reader:page">
    <xsl:sort select="@sampleID" data-type="number"/>
    <xsl:sort select="@number" data-type="number"/>
    <xsl:variable name="sampleID"><xsl:value-of select="@sampleID"/></xsl:variable>
    <xsl:variable name="number"><xsl:value-of select="@number"/></xsl:variable>

    <xsl:if test="count(preceding-sibling::*[@sampleID=$sampleID]) = 0">
<xsl:text disable-output-escaping="yes">
&lt;ss:Row ss:AutoFitHeight="0"&gt;</xsl:text>
    <ss:Cell><ss:Data ss:Type="Number"><xsl:value-of select="$sampleID"/></ss:Data></ss:Cell>
    </xsl:if>

    

    <ss:Cell><ss:Data ss:Type="Number"><xsl:value-of select="position()"/></ss:Data>
    </ss:Cell>

    <xsl:if test="count(following-sibling::*[@sampleID=$sampleID]) = 0">
<xsl:text disable-output-escaping="yes">
&lt;/ss:Row&gt;
</xsl:text>
    </xsl:if>

    </xsl:for-each>
</Table>
  <WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">
   <PageSetup>
    <Header x:Margin="0.51200000000000001"/>
    <Footer x:Margin="0.51200000000000001"/>
    <PageMargins x:Bottom="0.98399999999999999" x:Left="0.78700000000000003"
     x:Right="0.78700000000000003" x:Top="0.98399999999999999"/>
   </PageSetup>
   <ProtectObjects>False</ProtectObjects>
   <ProtectScenarios>False</ProtectScenarios>
  </WorksheetOptions>
 </Worksheet>
</Workbook>

</xsl:template>

</xsl:stylesheet>
