<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xforms="http://www.w3.org/2002/xforms"
 xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2"
 xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs"
 version="1.0">
	<xsl:param name="xforms.hint-attribute..sqs.prefix"/>
	<xsl:param name="xforms.hint-attribute..sqs.suffix"/>
	<xsl:param name="xforms.hint-attribute..sqs.display">inline</xsl:param>
	<xsl:param name="xforms.help-attribute..sqs.prefix">(</xsl:param>
	<xsl:param name="xforms.help-attribute..sqs.suffix">)</xsl:param>
	<xsl:param name="xforms.help-attribute..sqs.display">inline</xsl:param>
	<xsl:param name="xforms.alart-attribute..sqs.prefix">*</xsl:param>
	<xsl:param name="xforms.alart-attribute..sqs.suffix"/>
	<xsl:param name="xforms.alart-attribute..sqs.display">inline</xsl:param>

<!--
	<xsl:template match="xforms:textarea|xforms:input|xforms:select1|xforms:select|xforms:range|sqs:matrix-forms">
		<xhtml2:table xhtml2:class="question">
			<xhtml2:tbody>
				<xhtml2:tr>
					<xhtml2:td>
						<xsl:call-template name="xforms:label"/>
					</xhtml2:td>
					<xhtml2:td>
						<xsl:call-template name="xforms:hint"/>
						<xsl:call-template name="xforms:help"/>
						<xsl:call-template name="xforms:alart"/>
					</xhtml2:td>
				</xhtml2:tr>
				<xhtml2:tr>
					<xhtml2:td></xhtml2:td>
					<xhtml2:td>
						<xsl:choose>
							<xsl:when test="local-name()='matrix-forms'">
								<xsl:call-template name="sqs:matrix-forms"/>
							</xsl:when>
							<xsl:when test="local-name()='range'">
							</xsl:when>
							<xsl:otherwise>
								<xsl:copy-of select="."/>
							</xsl:otherwise>
						</xsl:choose>
					</xhtml2:td>
				</xhtml2:tr>
			</xhtml2:tbody>
		</xhtml2:table>
	</xsl:template>
-->

	<xsl:template match="xforms:textarea|xforms:input|xforms:select1|xforms:select|xforms:range|sqs:matrix-forms">
		<xhtml2:p>
			<xsl:call-template name="xforms:label"/>
			<xsl:call-template name="xforms:hint"/>
		</xhtml2:p>
		<xhtml2:p>
			<xsl:call-template name="xforms:help"/>
		</xhtml2:p>
		<xhtml2:p>
			<xsl:call-template name="xforms:alart"/>
		</xhtml2:p>

			<xsl:choose>
				<xsl:when test="local-name()='matrix-forms'">
					<xsl:call-template name="sqs:matrix-forms"/>
				</xsl:when>
				<xsl:when test="local-name()='range'">
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="."/>
				</xsl:otherwise>
			</xsl:choose>

	</xsl:template>

	<xsl:template name="xforms:label">
		<xsl:for-each select="xforms:label">
			<xsl:apply-templates/>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="xforms:hint">
		<xsl:variable name="diplay">
			<xsl:choose>
				<xsl:when test="0 &lt; string-length(@sqs:display)">
					<xsl:value-of select="@sqs:display"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$xforms.hint-attribute..sqs.display"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$diplay = 'inline' and 0 &lt; string-length(xforms:hint)">
			<xsl:choose>
				<xsl:when test="0 &lt; string-length(@sqs:prefix)">
					<xsl:value-of select="@sqs:prefix"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$xforms.hint-attribute..sqs.prefix"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select="xforms:hint">
				<xsl:apply-templates/>
			</xsl:for-each>
			<xsl:choose>
				<xsl:when test="0 &lt; string-length(@sqs:suffix)">
					<xsl:value-of select="@sqs:suffix"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$xforms.hint-attribute..sqs.suffix"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="xforms:help">
		<xsl:variable name="diplay">
			<xsl:choose>
				<xsl:when test="0 &lt; string-length(@sqs:display)">
					<xsl:value-of select="@sqs:display"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$xforms.help-attribute..sqs.display"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$diplay = 'inline' and 0 &lt; string-length(xforms:help)">
			<xsl:choose>
				<xsl:when test="0 &lt; string-length(@sqs:prefix)">
					<xsl:value-of select="@sqs:prefix"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$xforms.help-attribute..sqs.prefix"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select="xforms:help">
				<xsl:apply-templates/>
			</xsl:for-each>
			<xsl:choose>
				<xsl:when test="0 &lt; string-length(@sqs:suffix)">
					<xsl:value-of select="@sqs:suffix"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$xforms.help-attribute..sqs.suffix"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>

	<xsl:template name="xforms:alart">
		<xsl:variable name="diplay">
			<xsl:choose>
				<xsl:when test="0 &lt; string-length(@sqs:display)">
					<xsl:value-of select="@sqs:display"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$xforms.alart-attribute..sqs.display"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$diplay = 'inline' and 0 &lt; string-length(xforms:alart)">
			<xsl:choose>
				<xsl:when test="0 &lt; string-length(@sqs:prefix)">
					<xsl:value-of select="@sqs:prefix"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$xforms.alart-attribute..sqs.prefix"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select="xforms:alart">
				<xsl:apply-templates/>
			</xsl:for-each>
			<xsl:choose>
				<xsl:when test="0 &lt; string-length(@sqs:suffix)">
					<xsl:value-of select="@sqs:suffix"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$xforms.alart-attribute..sqs.suffix"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
