<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xforms="http://www.w3.org/2002/xforms"
 xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2"
 xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs"
 version="1.0">
	<xsl:template match="xforms:range">
		<xsl:variable name="times">
			<xsl:value-of select="1 + round((number(@xforms:end)-number(@xforms:start)) div number(@xforms:step))"/>
		</xsl:variable>
		<xsl:for-each select="xforms:indicator">
			<xhtml2:div>
				<xsl:apply-templates select="xforms:label"/>:<xsl:value-of select="@xforms:value"/>
			</xhtml2:div>
		</xsl:for-each>
		<xsl:call-template name="range-select">
			<xsl:with-param name="times">
				<xsl:value-of select="$times"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name="range-item">
		<xsl:param name="total"/>
		<xsl:param name="times"/>
		<xsl:variable name="value">
			<xsl:value-of select="( number($total) -  number($times)) * number(@xforms:step)"/>
		</xsl:variable>
		<xforms:item>
			<xforms:label>
				<xsl:value-of select="$value"/>
			</xforms:label>
			<xforms:value>
				<xsl:value-of select="$value"/>
			</xforms:value>
		</xforms:item>
	</xsl:template>

	<xsl:template name="range-loop">
		<xsl:param name="label"/>
		<xsl:param name="total"/>
		<xsl:param name="times"/>
		<xsl:param name="value"/>
		<xsl:if test="$times &gt;= 0">
			<xsl:copy-of select="$value"/>
			<xsl:call-template name="range-loop">
				<xsl:with-param name="total">
					<xsl:value-of select="$total"/>
				</xsl:with-param>
				<xsl:with-param name="times">
					<xsl:value-of select="$times - 1"/>
				</xsl:with-param>
				<xsl:with-param name="value">
					<xsl:call-template name="range-item">
						<xsl:with-param name="total">
							<xsl:value-of select="$total"/>
						</xsl:with-param>
						<xsl:with-param name="times">
							<xsl:value-of select="$times"/>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="range-select">
		<xsl:param name="times"/>
		<xforms:select1 sqs:pxform-type="range" sqs:qid="@sqs:qid">
			<xsl:call-template name="xforms:label"/>
			<xsl:call-template name="xforms:hint"/>
			<xsl:call-template name="xforms:help"/>
			<xsl:call-template name="xforms:alart"/>
			<xsl:call-template name="range-loop">
				<xsl:with-param name="total">
					<xsl:value-of select="$times"/>
				</xsl:with-param>
				<xsl:with-param name="times">
					<xsl:value-of select="$times"/>
				</xsl:with-param>
			</xsl:call-template>
		</xforms:select1>
	</xsl:template>
</xsl:stylesheet>
