<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xhtml="http://www.w3.org/1999/xhtml"
 xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2"
 xmlns:xforms="http://www.w3.org/2002/xforms"
 version="1.0">
<xsl:param name="form-submit-label">Submit</xsl:param>
	<xsl:template match="xhtml2:*">
		<xsl:element name="{local-name()}">
			<xsl:for-each select="@xhtml2:*|@*">
				<xsl:attribute name="{local-name()}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates select="child::node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="xforms:*">
		<xsl:element name="xforms:{local-name()}">
			<xsl:for-each select="@*">
				<xsl:attribute name="{name()}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates select="child::node()"/>
		</xsl:element>
	</xsl:template>

	<xsl:template match="xhtml2:html">
		<xhtml:html>
			<xsl:apply-templates/>
		</xhtml:html>
	</xsl:template>

	<xsl:template match="xhtml2:title">
		<xhtml:title>
			<xsl:apply-templates/>
		</xhtml:title>
	</xsl:template>
<!--
	<xsl:template match="xhtml2:meta">
		<xhtml:meta>
			<xsl:apply-templates/>
		</xhtml:meta>
	</xsl:template>
-->
	<xsl:template match="xhtml2:p">
		<xhtml:p>
			<xsl:apply-templates/>
		</xhtml:p>
	</xsl:template>

	<xsl:template match="xhtml2:table">
		<xhtml:table>
			<xsl:apply-templates/>
		</xhtml:table>
	</xsl:template>

	<xsl:template match="xhtml2:thead">
		<xhtml:thead>
			<xsl:apply-templates/>
		</xhtml:thead>
	</xsl:template>

	<xsl:template match="xhtml2:tbody">
		<xhtml:tbody>
			<xsl:apply-templates/>
		</xhtml:tbody>
	</xsl:template>

	<xsl:template match="xhtml2:tfoot">
		<xhtml:tfoot>
			<xsl:apply-templates/>
		</xhtml:tfoot>
	</xsl:template>

	<xsl:template match="xhtml2:tr">
		<xhtml:tr>
			<xsl:apply-templates/>
		</xhtml:tr>
	</xsl:template>

	<xsl:template match="xhtml2:th">
		<xhtml:th>
			<xsl:for-each select="@xhtml2:*|@*">
				<xsl:attribute name="{local-name()}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates/>
		</xhtml:th>
	</xsl:template>

	<xsl:template match="xhtml2:td">
		<xhtml:td>
			<xsl:for-each select="@xhtml2:*|@*">
				<xsl:attribute name="{local-name()}"><xsl:value-of select="."/></xsl:attribute>
			</xsl:for-each>
			<xsl:apply-templates/>
		</xhtml:td>
	</xsl:template>

	<xsl:template match="xhtml2:body//xhtml2:h">
		<xhtml:h1>
			<xsl:apply-templates/>
		</xhtml:h1>
	</xsl:template>
	<xsl:template match="xhtml2:body//xhtml2:section/xhtml2:h">
		<xhtml:h2>
			<xsl:apply-templates/>
		</xhtml:h2>
	</xsl:template>
	<xsl:template match="xhtml2:body//xhtml2:section//xhtml2:section/xhtml2:h">
		<xhtml:h3>
			<xsl:apply-templates/>
		</xhtml:h3>
	</xsl:template>
	<xsl:template match="xhtml2:body//xhtml2:section//xhtml2:section/xhtml2:section/xhtml2:h">
		<xhtml:h4>
			<xsl:apply-templates/>
		</xhtml:h4>
	</xsl:template>
	<xsl:template match="xhtml2:section">
		<xsl:apply-templates/>
		<xhtml:hr/>
	</xsl:template>
	<xsl:template match="xhtml2:head">
		<xhtml:head>
			<xhtml:meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
			<xhtml:style type="text/css">
table{
 border-style: solid;
 border-width: 1px;
 border-color: black;
}
th,td{
 border-style: solid;
 border-width: 1px;
 border-color: black;
 vertical-align: top;
}
div.warning{
border-style: solid;
border-color: black;
border-width: 1px;
}
strong{
  text-decoration: underline;
}
        </xhtml:style>
			<xsl:apply-templates/>
		</xhtml:head>
	</xsl:template>
	<xsl:template match="xhtml2:body">
		<xhtml:body>
			<xhtml:form action="" method="post">
				<xsl:apply-templates/>
<xsl:if test="0 &lt; string-length($form-submit-label)">
  <xhtml:input type="submit" value="{$form-submit-label}"/>
</xsl:if>
			</xhtml:form>
		</xhtml:body>
	</xsl:template>
</xsl:stylesheet>
