<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:fo="http://www.w3.org/1999/XSL/Format"
 xmlns:xforms="http://www.w3.org/2002/xforms"
 xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2"
 version="1.0">

	<xsl:template match="xhtml2:body">
		<xsl:apply-templates/>
	</xsl:template>


	<xsl:template match="/xhtml2:html">
		<fo:root language="ja" xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<!-- FOP default = 72 dpi -->
			<!-- A4 portrait width : 595.2756 px = 210mm = 8.2677inch -->
			<!-- A4 portrait height: 841.8897 px = 290mm = 11.6929inch -->
			<xsl:call-template name="layout-master-set"/>
<!--			<xsl:call-template name="bookmark-tree"/>-->
			<xsl:call-template name="page-sequence"/>
		</fo:root>
	</xsl:template>


<!-- ########   1.  fo:layout-master-set 			 ######### -->
<!-- ########   1.1 fo:layout-master-set/fo:simple-page-master   ######### -->
<!-- ########   1.2 fo:layout-master-set/fo:region-body 	 ######### -->

	<xsl:template name="layout-master-set">
		<fo:layout-master-set>
			<xsl:choose>
				<xsl:when test="$sides='duplex'">

					<xsl:call-template name="simple-page-master">
						<xsl:with-param name="left-right">left</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="simple-page-master">
						<xsl:with-param name="left-right">right</xsl:with-param>
					</xsl:call-template>

					<fo:page-sequence-master master-name="page">
						<fo:repeatable-page-master-alternatives>
							<fo:conditional-page-master-reference odd-or-even="odd" master-reference="page-left"/>
							<fo:conditional-page-master-reference odd-or-even="even" master-reference="page-right"/>
						</fo:repeatable-page-master-alternatives>
					</fo:page-sequence-master>
				</xsl:when>
				<xsl:otherwise>

					<xsl:if test="$start-printing-side='left'">
						<xsl:call-template name="simple-page-master">
							<xsl:with-param name="left-right">left</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="$start-printing-side='right'">
						<xsl:call-template name="simple-page-master">
							<xsl:with-param name="left-right">right</xsl:with-param>
						</xsl:call-template>
					</xsl:if>
				</xsl:otherwise>
			</xsl:choose>
		</fo:layout-master-set>
	</xsl:template>


	<xsl:template name="simple-page-master">
		<xsl:param name="left-right"/>
		<fo:simple-page-master page-width="595.2756px" page-height="841.8897px" margin-top="0px" margin-bottom="0px" margin-left="0px" margin-right="0px" master-name="page-{$left-right}">

			<fo:region-body margin-top="60px" margin-bottom="60px" margin-left="44px" margin-right="44px"/>

			<xsl:choose>
			   <xsl:when test="$left-right='left' or $left-right='right'">
				<fo:region-before extent="60px" region-name="header-{$left-right}"/>
				<fo:region-after extent="60px" region-name="footer-{$left-right}"/>
			   </xsl:when>
			   <xsl:otherwise>
  		           </xsl:otherwise>
			</xsl:choose>

			<fo:region-start extent="0px"/>
			<fo:region-end extent="0px"/>

		</fo:simple-page-master>
	</xsl:template>

<!-- ########  bookmark ######### -->


<!-- ########   2.    fo:page-sequence                                			######### -->
<!-- ########   2.1   fo:page-sequence/fo:static-cotntent             			######### -->
<!-- ########   2.1.1 fo:page-sequence/fo:static-cotntent/fo:static-cotntent            ######### -->
<!-- ########   2.2   fo:page-sequence/fo:flow                        			######### -->

	<xsl:template name="page-sequence">

		<xsl:variable name="master-reference">page<xsl:choose>
				<xsl:when test="$sides!='duplex'">-<xsl:value-of select="$start-printing-side"/>
				</xsl:when>
				<xsl:otherwise/>
			</xsl:choose>
		</xsl:variable>

		<fo:page-sequence master-reference="{$master-reference}">

			<xsl:if test="$sides='duplex' or $start-printing-side='right'">
				<fo:static-content flow-name="header-right">
					<fo:block>
					<xsl:call-template name="xsl-region-before">
						<xsl:with-param name="left-right">right</xsl:with-param>
					</xsl:call-template>
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer-left">
					<fo:block>
					<xsl:call-template name="xsl-region-after">
						<xsl:with-param name="left-right">left</xsl:with-param>
					</xsl:call-template>
					</fo:block>
				</fo:static-content>
			</xsl:if>
			<xsl:if test="$sides='duplex' or $start-printing-side='left'">
				<fo:static-content flow-name="header-left">
					<fo:block>
					<xsl:call-template name="xsl-region-before">
						<xsl:with-param name="left-right">left</xsl:with-param>
					</xsl:call-template>
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer-right">
					<fo:block>
					<xsl:call-template name="xsl-region-after">
						<xsl:with-param name="left-right">right</xsl:with-param>
					</xsl:call-template>
					</fo:block>
				</fo:static-content>
			</xsl:if>

			<fo:static-content flow-name="xsl-region-end">
				<fo:block>
				<xsl:call-template name="xsl-region-end"></xsl:call-template>
				</fo:block>
			</fo:static-content>

			<fo:flow flow-name="xsl-region-body">
				<fo:block id="originator"/>
				<xsl:apply-templates select="xhtml2:body"/>
				<fo:block id="terminator"/>
			</fo:flow>

		</fo:page-sequence>
	</xsl:template>


</xsl:stylesheet>
