<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:fo="http://www.w3.org/1999/XSL/Format"
 version="1.0">
<xsl:param name="characters-prohibit-line-break">)}].,</xsl:param>
<xsl:template match="text()">
	<xsl:call-template name="kinsoku">
		<xsl:with-param name="tail" select="."/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="kinsoku">
	<xsl:param name="tail"/>
	<xsl:if test="string-length($tail) != 0">
		<xsl:variable name="head" select="substring($tail, 1, 1)"/>
		<xsl:choose>
			<xsl:when test="contains($characters-prohibit-line-break, $head)">
				<fo:inline wrap-option="no-wrap">
					<xsl:value-of select="$head"/>
				</fo:inline>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$head"/>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:call-template name="kinsoku">
			<xsl:with-param name="tail" select="substring($tail, 2)"/>
		</xsl:call-template>
	</xsl:if>
</xsl:template>
</xsl:stylesheet>
