<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:fo="http://www.w3.org/1999/XSL/Format"
 xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2"
 xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs"
 version="1.0">
	<xsl:template match="sqs:pageset">
		<fo:block page-brake-after="always">
			<xsl:apply-templates/>
		</fo:block>
	</xsl:template>
	<xsl:template match="sqs:warning">
		<fo:block xsl:use-attribute-sets="textbox">
			<xsl:apply-templates/>
		</fo:block>
	</xsl:template>
	<xsl:template match="xhtml2:p">
		<fo:block xsl:use-attribute-sets="p">
			<fo:inline color="white"> </fo:inline>
			<xsl:apply-templates/>
		</fo:block>
	</xsl:template>

	<xsl:template match="xhtml2:section">
		<fo:block id="{@id}">
			<xsl:apply-templates/>
		</fo:block>
	</xsl:template>

	<xsl:template match="xhtml2:h">
		<fo:block xsl:use-attribute-sets="h">
			<!--     xsl:keep-with-next="always"-->
			<xsl:apply-templates/>
		</fo:block>
	</xsl:template>

	<xsl:template match="xhtml2:ul|xhtml2:ol">
		<fo:list-block>
			<xsl:apply-templates/>
		</fo:list-block>
	</xsl:template>
	<xsl:template match="xhtml2:li">
		<fo:list-item>
			<fo:list-item-label start-indent="inherit+5mm" end-indent="label-end()">
				<xsl:choose>
					<xsl:when test="local-name(parent::node()) = 'ul'">
						<fo:block>&#x02022;</fo:block>
					</xsl:when>
					<xsl:when test="local-name(parent::node()) = 'ol'">
						<fo:block>
							<xsl:number level="multiple" count="xhtml2:li" from="xhtml2:ul" format="1."/>
						</fo:block>
					</xsl:when>
				</xsl:choose>
			</fo:list-item-label>
			<fo:list-item-body start-indent="body-start()">
				<fo:block>
					<xsl:apply-templates/>
				</fo:block>
			</fo:list-item-body>
		</fo:list-item>
	</xsl:template>
</xsl:stylesheet>
