<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2" version="1.0">

	<xsl:template name="xsl-region-before">
		<xsl:param name="left-right"/>

		<xsl:choose>
			<xsl:when test="$left-right='left'">

				<fo:block-container border-color="white" border-style="solid" border-width="0mm" height="60px" width="60px" top="10px" padding="0px" position="absolute" left="0px">
				  <fo:block>
					<fo:instream-foreign-object>
						<xsl:call-template name="staple">
							<xsl:with-param name="left-right">
								<xsl:value-of select="$left-right"/>
							</xsl:with-param>
						</xsl:call-template>
					</fo:instream-foreign-object>
				  </fo:block>
				</fo:block-container>

			</xsl:when>

			<xsl:when test="$left-right='right'">
				<fo:block-container border-color="white" border-style="solid" border-width="0mm" height="60px" width="60px" top="10px" left="595.2756px - 60px" padding="0px" position="absolute">
				  <fo:block>
					<fo:instream-foreign-object>
						<xsl:call-template name="staple">
							<xsl:with-param name="left-right">
								<xsl:value-of select="$left-right"/>
							</xsl:with-param>
						</xsl:call-template>
					</fo:instream-foreign-object>
				  </fo:block>
				</fo:block-container>
			</xsl:when>

		</xsl:choose>

		<fo:block-container xsl:use-attribute-sets="scan-guide">
			<fo:block>
				<fo:instream-foreign-object>
					<xsl:call-template name="scan-guide-top"/>
				</fo:instream-foreign-object>
			</fo:block>
		</fo:block-container>

	</xsl:template>

	<xsl:template name="xsl-region-after">
		<xsl:param name="left-right"/>

		<xsl:choose>

			<xsl:when test="$left-right='left'">
				<fo:block-container border-color="white"
				border-style="solid" border-width="0mm"
				height="40px" width="45px" top="5px"  left="595.2756px - 80px" 
				padding="0px" position="absolute" display-align="center">

					<xsl:call-template name="page-number"/>

					<xsl:if test="$show-enqtitle-below-pagenum">
						<xsl:call-template name="page-title"/>
					</xsl:if>

				</fo:block-container>
			</xsl:when>

			<xsl:when test="$left-right='right'">
				<fo:block-container border-color="white"
				border-style="solid" border-width="0mm"
				height="40px" width="45px" top="5px" left="15px"
				padding="0px" position="absolute" display-align="center">

					<xsl:call-template name="page-number"/>

					<xsl:if test="$show-enqtitle-below-pagenum">
						<xsl:call-template name="page-title"/>
					</xsl:if>

				</fo:block-container>
			</xsl:when>

		</xsl:choose>
		<fo:block-container xsl:use-attribute-sets="scan-guide">
			<fo:block>
				<fo:instream-foreign-object>
					<xsl:call-template name="scan-guide-bottom"/>
				</fo:instream-foreign-object>
			</fo:block>
		</fo:block-container>
	</xsl:template>


	<xsl:template name="page-number">
		<fo:block display-align="center" xsl:use-attribute-sets="page-number">
			<fo:page-number/> / <fo:page-number-citation ref-id="terminator"/>
		</fo:block>
	</xsl:template>

	<xsl:template name="page-title">
		<fo:block display-align="center" xsl:use-attribute-sets="qtitle-below-page-number">
			<xsl:variable name="title"><xsl:value-of select="/xhtml2:html/xhtml2:head/xhtml2:meta[@name='DC.Title.Short']/@content"/></xsl:variable>
			<xsl:choose>
				<xsl:when test="0 &lt; string-length($title)"><xsl:value-of select="$title"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="/xhtml2:html/xhtml2:head/xhtml2:title"/></xsl:otherwise>
			</xsl:choose>
		</fo:block>
	</xsl:template>

</xsl:stylesheet>
