<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:fo="http://www.w3.org/1999/XSL/Format"
 xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2"
 xmlns:xforms="http://www.w3.org/2002/xforms"
 xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs"
 version="1.0">
    <xsl:param name="bookmark-root-label">Bookmark</xsl:param>
    <xsl:param name="bookmark-section-label">Section</xsl:param>
    <xsl:param name="bookmark-question-label">Question</xsl:param>
    <xsl:param name="bookmark-itemset-label">Itemset</xsl:param>
	<xsl:template match="/">
		<xhtml2:html>
			<xhtml2:head>
				<fo:bookmark-tree>
				  <fo:bookmark internal-destination="originator">
					<fo:bookmark-title><xsl:value-of select="$bookmark-root-label"/></fo:bookmark-title>
					<xsl:apply-templates select="xhtml2:html/xhtml2:body" mode="bookmark"/>
				  </fo:bookmark>
				</fo:bookmark-tree>
			</xhtml2:head>
			<xsl:apply-templates select="xhtml2:html/xhtml2:body"/>
		</xhtml2:html>
	</xsl:template>
	<xsl:template match="xhtml2:*" mode="bookmark">
		<xsl:apply-templates select="xhtml2:*|xforms:*" mode="bookmark"/>
	</xsl:template>
	<xsl:template match="xhtml2:section" mode="bookmark">
		<fo:bookmark internal-destination="{@id}">
			<!-- section -->
			<fo:bookmark-title>
				<xsl:value-of select="xhtml2:h"/>
			</fo:bookmark-title>
			<xsl:apply-templates select="xhtml2:*|xforms:*" mode="bookmark"/>
		</fo:bookmark>
	</xsl:template>
	
	<xsl:template match="xforms:*" mode="bookmark">
		<fo:bookmark internal-destination="{$internal-destination-prefix-question}{@sqs:qid}">
			<fo:bookmark-title>
				<xsl:value-of select="xforms:label"/>
				<xsl:value-of select="xforms:hint"/>
			</fo:bookmark-title>
			<xsl:call-template name="outline-xform">
				<xsl:with-param name="dest"><xsl:value-of select="$internal-destination-prefix-question"/><xsl:value-of select="@sqs:qid"/></xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="outline-xforms-itemset">
				<xsl:with-param name="dest"><xsl:value-of select="$internal-destination-prefix-question"/><xsl:value-of select="@sqs:qid"/></xsl:with-param>
			</xsl:call-template>
		</fo:bookmark>
	</xsl:template>
	
	<xsl:template name="outline-xform">
		<xsl:param name="dest"/>
			<fo:bookmark internal-destination="{$dest}">
				<fo:bookmark-title><xsl:value-of select="$bookmark-question-label"/></fo:bookmark-title>
				<fo:bookmark internal-destination="{$dest}">
					<fo:bookmark-title>type=<xsl:value-of select="local-name()"/>
					</fo:bookmark-title>
				</fo:bookmark>
				<fo:bookmark internal-destination="{$dest}">
					<fo:bookmark-title>label=<xsl:value-of select="xforms:label"/>
					</fo:bookmark-title>
				</fo:bookmark>
				<fo:bookmark internal-destination="{$dest}">
					<fo:bookmark-title>hint=<xsl:value-of select="xforms:hint"/>
					</fo:bookmark-title>
				</fo:bookmark>
				<fo:bookmark internal-destination="{$dest}">
					<fo:bookmark-title>help=<xsl:value-of select="xforms:help"/>
					</fo:bookmark-title>
				</fo:bookmark>
				<fo:bookmark internal-destination="{$dest}">
					<fo:bookmark-title>alart=<xsl:value-of select="xforms:alart"/>
					</fo:bookmark-title>
				</fo:bookmark>
				<xsl:if test="local-name()='textarea' or local-name()='input'">
					<fo:bookmark internal-destination="{$dest}">
						<fo:bookmark-title>page=<xsl:value-of select="ancestor-or-self::node()/attribute::sqs:qid"/></fo:bookmark-title>
					</fo:bookmark>
					<fo:bookmark internal-destination="{$dest}">
						<fo:bookmark-title>dimension=<xsl:value-of select="ancestor-or-self::node()/attribute::sqs:qid"/></fo:bookmark-title>
					</fo:bookmark>
				</xsl:if>
				<fo:bookmark internal-destination="{$internal-destination-prefix-question}{ancestor-or-self::node()/attribute::sqs:qid}">
					<fo:bookmark-title>qid=<xsl:value-of select="ancestor-or-self::node()/attribute::sqs:qid"/>
					</fo:bookmark-title>
				</fo:bookmark>
			</fo:bookmark>
	</xsl:template>
	<xsl:template name="outline-xforms-itemset">
		<xsl:param name="dest"/>
			<xsl:choose>
				<xsl:when test="xforms:item">
					<fo:bookmark internal-destination="{$dest}">
						<fo:bookmark-title><xsl:value-of select="$bookmark-itemset-label"/></fo:bookmark-title>
						<xsl:for-each select="xforms:item">
							<fo:bookmark internal-destination="{$internal-destination-prefix-xform}{ancestor-or-self::node()/attribute::sqs:qid}/v{xforms:value}">
								<fo:bookmark-title>label=<xsl:value-of select="xforms:label"/>
								</fo:bookmark-title>
								<fo:bookmark internal-destination="{$internal-destination-prefix-xform}{ancestor-or-self::node()/attribute::sqs:qid}/v{xforms:value}">
									<fo:bookmark-title>value=<xsl:value-of select="xforms:value"/></fo:bookmark-title>
								</fo:bookmark>
								<fo:bookmark internal-destination="{$internal-destination-prefix-xform}{ancestor-or-self::node()/attribute::sqs:qid}/v{xforms:value}">
									<fo:bookmark-title>page=<xsl:value-of select="ancestor-or-self::node()/attribute::sqs:qid"/>/v<xsl:value-of select="xforms:value"/></fo:bookmark-title>
								</fo:bookmark>
								<fo:bookmark internal-destination="{$internal-destination-prefix-xform}{ancestor-or-self::node()/attribute::sqs:qid}/v{xforms:value}">
									<fo:bookmark-title>dimension=<xsl:value-of select="ancestor-or-self::node()/attribute::sqs:qid"/>/v<xsl:value-of select="xforms:value"/></fo:bookmark-title>
								</fo:bookmark>
							</fo:bookmark>
						</xsl:for-each>
					</fo:bookmark>
				</xsl:when>
			</xsl:choose>
	</xsl:template>
	<xsl:template match="xhtml2:table[@xhtml2:class='matrix-forms']" mode="bookmark">
		<fo:bookmark internal-destination="{$internal-destination-prefix-question}{@id}">
			<xsl:variable name="label"><xsl:value-of select="ancestor::xhtml2:table[@xhtml2:class='question']/xhtml2:tbody/xhtml2:tr/xhtml2:td[1]"/></xsl:variable>
			<xsl:variable name="composit-label"><xsl:value-of select="ancestor::xhtml2:table[@xhtml2:class='question']/xhtml2:tbody/xhtml2:tr/xhtml2:td[2]"/></xsl:variable>
			<fo:bookmark-title>
				<xsl:value-of select="$label"/>
				<xsl:value-of select="ancestor::xhtml2:table[@xhtml2:class='question']/xhtml2:tbody/xhtml2:tr/xhtml2:td[2]"/>
			</fo:bookmark-title>
			
			<fo:bookmark internal-destination="{$internal-destination-prefix-question}{@id}">
				<fo:bookmark-title><xsl:value-of select="$bookmark-question-label"/></fo:bookmark-title>
				<fo:bookmark internal-destination="{$internal-destination-prefix-question}{@id}">
				<fo:bookmark-title>type=matrix-forms</fo:bookmark-title>
				</fo:bookmark>
				<fo:bookmark internal-destination="{$internal-destination-prefix-question}{@id}">
				<fo:bookmark-title>label=<xsl:value-of select="$label"/></fo:bookmark-title>
				</fo:bookmark>
				<fo:bookmark internal-destination="{$internal-destination-prefix-question}{@id}">
				<fo:bookmark-title>hint=<xsl:value-of select="substring-before($composit-label,'(')"/></fo:bookmark-title>
				</fo:bookmark>
				<fo:bookmark internal-destination="{$internal-destination-prefix-question}{@id}">
				<fo:bookmark-title>help=<xsl:value-of select="substring-before(substring-after($composit-label,'('), ')')"/></fo:bookmark-title>
				</fo:bookmark>
			</fo:bookmark>
			
			<xsl:for-each select="ancestor::xhtml2:table[@xhtml2:class='question']/xhtml2:tbody/xhtml2:tr[2]/xhtml2:td[2]/xhtml2:table/xhtml2:tbody/xhtml2:tr">
				<xsl:variable name="dest"><xsl:value-of select="@id"/></xsl:variable>
				<fo:bookmark internal-destination="{$dest}">
					<fo:bookmark-title><xsl:value-of select="xhtml2:th[1]"/><xsl:text>:</xsl:text><xsl:value-of select="xhtml2:td[1]"/></fo:bookmark-title>
					<fo:bookmark internal-destination="{$dest}">
						<fo:bookmark-title><xsl:value-of select="$bookmark-question-label"/></fo:bookmark-title>
						<fo:bookmark internal-destination="{$dest}">
							<fo:bookmark-title>type=matrix-forms-row</fo:bookmark-title>
						</fo:bookmark>						
						<fo:bookmark internal-destination="{$dest}">
							<fo:bookmark-title>label=<xsl:value-of select="xhtml2:th[1]"/></fo:bookmark-title>
						</fo:bookmark>						
						<fo:bookmark internal-destination="{$dest}">
							<fo:bookmark-title>hint=<xsl:value-of select="xhtml2:td[1]"/></fo:bookmark-title>
						</fo:bookmark>
					</fo:bookmark>
					<xsl:call-template name="outline-matrix-forms-cell">
						<xsl:with-param name="qid"><xsl:value-of select="$label"/></xsl:with-param>
						<xsl:with-param name="rowid"><xsl:number level="any" from="xhtml2:tbody" count="xhtml2:tr"/></xsl:with-param>
						<xsl:with-param name="dest"><xsl:value-of select="$dest"/></xsl:with-param>
					</xsl:call-template>
				</fo:bookmark>
			</xsl:for-each>

		</fo:bookmark>

	</xsl:template>
	<xsl:template name="outline-matrix-forms-cell">
		<xsl:param name="qid"/>	
		<xsl:param name="rowid"/>
		<xsl:param name="dest"/>
		<xsl:for-each select="ancestor::xhtml2:table[@xhtml2:class='matrix-forms']/xhtml2:thead/xhtml2:tr[1]/xhtml2:th[1 &lt; position()]">
			<xsl:variable name="form-number"><xsl:value-of select="position()"/></xsl:variable>
			
			<fo:bookmark internal-destination="{$dest}">
				<fo:bookmark-title><xsl:value-of select="."/></fo:bookmark-title>
				<xsl:variable name="column-group-index" select="@sqs:column-group-index"/>
				<xsl:variable name="colid"><xsl:number level="any" from="xhtml2:tr" count="xhtml2:th[1 &lt; position()]"/></xsl:variable>
				<xsl:variable name="qid"><xsl:value-of select="substring-after($dest, 'Question-')"/>/c[<xsl:value-of select="$form-number"/>]</xsl:variable>
				<fo:bookmark internal-destination="{$dest}">
						<fo:bookmark-title><xsl:value-of select="$bookmark-question-label"/></fo:bookmark-title>
			<fo:bookmark internal-destination="{$dest}">
				<fo:bookmark-title>type=<xsl:value-of select="@sqs:xforms-type"/></fo:bookmark-title>
			</fo:bookmark>
			<fo:bookmark internal-destination="{$dest}">
				<fo:bookmark-title>label=<xsl:value-of select="$qid"/><xsl:value-of select="$rowid"/>-<xsl:value-of select="$colid"/></fo:bookmark-title>
			</fo:bookmark>
			<fo:bookmark internal-destination="{$dest}">
				<fo:bookmark-title>hint=<xsl:value-of select="."/></fo:bookmark-title>
			</fo:bookmark>
			<fo:bookmark internal-destination="{$dest}">
				<fo:bookmark-title>help=</fo:bookmark-title>
			</fo:bookmark>
			<fo:bookmark internal-destination="{$dest}">
				<fo:bookmark-title>alart=</fo:bookmark-title>
			</fo:bookmark>

			<xsl:if test="@sqs:pxform-type='textarea' or @sqs:xforms-type='input'">
				<fo:bookmark internal-destination="{$dest}">
					<fo:bookmark-title>page=<xsl:value-of select="$qid"/></fo:bookmark-title>
				</fo:bookmark>
				<fo:bookmark internal-destination="{$dest}">
					<fo:bookmark-title>dimension=<xsl:value-of select="$qid"/></fo:bookmark-title>
				</fo:bookmark>
			</xsl:if>
						
			<fo:bookmark internal-destination="{$dest}">
				<fo:bookmark-title>qid=<xsl:value-of select="$qid"/></fo:bookmark-title>
			</fo:bookmark>

				</fo:bookmark>

			<xsl:if test="@sqs:pxform-type='select' or @sqs:xforms-type='select1'">
				<fo:bookmark internal-destination="{$dest}">
					<fo:bookmark-title><xsl:value-of select="$bookmark-itemset-label"/></fo:bookmark-title>
<xsl:for-each select="ancestor::xhtml2:table[@xhtml2:class='matrix-forms']/xhtml2:thead/xhtml2:tr[2]/xhtml2:th[@sqs:column-group-index = $column-group-index]">
	<fo:bookmark internal-destination="{$dest}">
		<fo:bookmark-title>label=<xsl:value-of select="."/></fo:bookmark-title>
		<fo:bookmark internal-destination="{$dest}">
			<fo:bookmark-title>value=<xsl:value-of select="@sqs:value"/></fo:bookmark-title>
		</fo:bookmark>
		<fo:bookmark internal-destination="{$dest}">
			<fo:bookmark-title>page=<xsl:value-of select="$qid"/>/v<xsl:value-of select="@sqs:value"/></fo:bookmark-title>
		</fo:bookmark>
		<fo:bookmark internal-destination="{$dest}">
			<fo:bookmark-title>dimension=<xsl:value-of select="$qid"/>/v<xsl:value-of select="@sqs:value"/></fo:bookmark-title>
		</fo:bookmark>
	</fo:bookmark>
</xsl:for-each>
				</fo:bookmark>

			</xsl:if>
				
			</fo:bookmark>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
