/*

 SourceFactory.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/03

 */
package net.sqs2.exsed.module.sqs.source;

import java.io.File;
import java.net.URL;

import net.sqs2.exsed.source.Source;
import net.sqs2.exsed.source.SourceException;
import net.sqs2.exsed.source.SourceFactory;


/**
 * @author hiroya
 *
 */
public class SQSSourceFactory implements SourceFactory {

    public SQSSourceFactory(){
        super();
    }
    
    public Source createSource()throws SourceException{
        return new SQSSource();
    }

    public Source createSource(File file)throws SourceException{
        return new SQSSource(file);
    }

    public Source createSource(URL url, boolean readonly, String title)throws SourceException{
        return new SQSSource(url, readonly, title);
    }
}
