package net.sqs2.exsed.module.sqs.source;

import java.awt.Container;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JFrame;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.MimeConstants;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.render.awt.viewer.PreviewPanel;
import org.apache.fop.render.awt.viewer.Renderable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

import net.sqs2.editor.EditorConstants;
import net.sqs2.editor.SourceEditorJarURIContext;
import net.sqs2.net.ClassURIResolver;
import net.sqs2.net.ClassURLStreamHandlerFactory;
import net.sqs2.translator.AbstractTranslator;
import net.sqs2.translator.TranslatorException;
import net.sqs2.translator.XSLTranslator;
import net.sqs2.util.FileUtil;

public abstract class FOPTranslator extends AbstractTranslator {

	static{
		try{
			URL.setURLStreamHandlerFactory(new ClassURLStreamHandlerFactory());
		}catch(Error ignore){}
	}
	
	private final static boolean DEBUG = false; 

	private final static URIResolver uriResolver = new ClassURIResolver();
	protected static SQSToPDFTranslatorCore core;
	
	static{
		try{
			core = new SQSToPDFTranslatorCore();
		}catch(TranslatorException ex){
			ex.printStackTrace();
		}
	}

	public FOPTranslator() throws TranslatorException{
	}
	
	static class PreviewFrame extends JFrame{
		private static final long serialVersionUID = 0L;
		private FOUserAgent userAgent;
		private PreviewPanel previewPanel;
		
		PreviewFrame(FOUserAgent userAgent){
			this.setSize(400, 550);
			this.userAgent = userAgent;
		}
		
		void update(String title, Renderable renderable, AWTRenderer renderer){
			Container contentPane = this.getContentPane();
			if(0 < contentPane.getComponentCount()){
				contentPane.remove(0);
			}
			this.previewPanel = new PreviewPanel(this.userAgent, renderable, renderer);
			contentPane.add(this.previewPanel);
			this.setTitle(title);
		}
		
		void render(Renderable renderable, AWTRenderer renderer)throws FOPException{
			renderer.setRenderable(renderable);
            renderer.clearViewportList();
			renderable.renderTo(this.userAgent, MimeConstants.MIME_FOP_AWT_PREVIEW);
		}
		
		void show(AWTRenderer renderer)throws FOPException{
			double scale = this.previewPanel.getScaleToFitWindow();
			this.previewPanel.setDisplayMode(PreviewPanel.CONTINUOUS);
			this.previewPanel.setScaleFactor(scale);
			renderer.clearViewportList();
			this.previewPanel.reload(); 
		}		
	}
	
	static class SQSToPDFTranslatorCore{
		private final String[] SQS2FO = EditorConstants.getResourceBundle().getString("sqs2fo_xsl_file").split(" ");
		private String baseURI;
		private XSLTranslator xslTranslator;
		
		private FopFactory fopFactory;
		private FOUserAgent userAgent;
		private PreviewFrame previewFrame;
		
		public SQSToPDFTranslatorCore()throws TranslatorException{
			try{
				this.baseURI = SourceEditorJarURIContext.getXSLTBaseURI();
				this.xslTranslator = new XSLTranslator();
				this.xslTranslator.initialize(baseURI, SQS2FO, getParameterArrayMap());

				try{
					this.fopFactory = FopFactory.newInstance();
					this.fopFactory.setURIResolver(uriResolver);
					this.fopFactory.setUserConfig(SourceEditorJarURIContext.getFOPUserConfigURI());
					/*
					this.fopFactory.setFontBaseURL("class://net.sqs2.editor.Anchor/");
					this.fopFactory.setHyphenBaseURL("class://net.sqs2.editor.Anchor/");
					this.fopFactory.setStrictValidation(false);
					this.fopFactory.setBreakIndentInheritanceOnReferenceAreaBoundary(true);
					this.fopFactory.setSourceResolution(72);
					*/
				}catch(MalformedURLException ex){
					ex.printStackTrace();
				}catch(SAXException ex){			
					ex.printStackTrace();
				}catch(IOException ex){
					ex.printStackTrace();
				}

				this.userAgent = createFOUserAgent();
				
			}catch(Exception ex){
				ex.printStackTrace();
				throw new TranslatorException(ex);
			}
		}
		
		FOUserAgent getUserAgent(){
			return this.userAgent;
		}
		
		AWTRenderer createAWTRenderer(){
			AWTRenderer renderer = new AWTRenderer();
			renderer.setPreviewDialogDisplayed(false);
			renderer.setUserAgent(this.userAgent);
			this.userAgent.setRendererOverride(renderer);
			return renderer;
		}

		private Map<String,Entry[]> getParameterArrayMap() {
			Map<String,Entry[]> ret = new HashMap<String,Entry[]>(); 
			ret.put("embed-counter.xsl", new Entry[]{
					new Entry("xhtml.h-attribute..sqs.prefix", "問"),
					new Entry("xhtml.h-attribute..sqs.suffix", "."),
					new Entry("xhtml.h-attribute..sqs.format", "1"),
					new Entry("sqs.counter-attribute..sqs.prefix", "("),
					new Entry("sqs.counter-attribute..sqs.suffix", ")"),
					new Entry("sqs.counter-attribute..sqs.format", "1")});

			ret.put("pxformsConvert1.xsl", new Entry[]{
					new Entry("xforms.hint-attribute..sqs.prefix",""),
					new Entry("xforms.hint-attribute..sqs.suffix", ""),
					new Entry("xforms.hint-attribute..sqs.display", "inline"),
					new Entry("xforms.help-attribute..sqs.prefix","("),
					new Entry("xforms.help-attribute..sqs.suffix",")"),
					new Entry("xforms.help-attribute..sqs.display","inline"),
					new Entry("xforms.alart-attribute..sqs.prefix","*"),
					new Entry("xforms.alart-attribute..sqs.suffix",""),
					new Entry("xforms.alart-attribute..sqs.display","inline")});

			ret.put("xhtmlToBookmark.xsl ", new Entry[]{
					new Entry("bookmark-root-label","調査票の構造"),
					new Entry("bookmark-section-label","問"),			
					new Entry("bookmark-question-label","設問"),
					new Entry("bookmark-itemset-label","選択肢")
			});

			ret.put("pxformsToFO.xsl", new Entry[]{
					new Entry("example-blank-mark-label", " : 空白マークの例"),
					new Entry("example-filled-mark-label", ": 正しい塗り潰しの例"),
					new Entry("example-incomplete-mark-label", ": 不十分な塗り潰しの例"),
					new Entry("characters-prohibit-line-break",
					"。．、，’”）｝」』〕】〉》々〜…ーぁぃぅぇぉっゃゅょゎァィゥェォッャュョヮ)'")
					/* 
	    			“‘（｛「『〔【〈《(￥＄
					 */
			});
			return ret;
		}

		private FOUserAgent createFOUserAgent(){
			FOUserAgent userAgent;
			userAgent = this.fopFactory.newFOUserAgent();
			userAgent.setProducer("SQS SourceEditor2.0");
			userAgent.setCreator("");//Hiroya KUBO
			userAgent.setAuthor("");//Hiroya KUBO
			userAgent.setCreationDate(new Date());
			userAgent.setTitle(""); // TODO
			userAgent.setKeywords("SQS XML XSL-FO");
			userAgent.setBaseURL("class://net.sqs2.editor.Anchor/");
			userAgent.setURIResolver(uriResolver);
			return userAgent;
		}
		
		PreviewFrame getPreviewFrame(String title, Renderable renderable, AWTRenderer renderer){
			if(this.previewFrame == null){
				this.previewFrame = new PreviewFrame(this.userAgent);				
			}
			this.previewFrame.update(title, renderable, renderer);
			return previewFrame;
		}

		Fop createFop(FOUserAgent userAgent, String outputFormat)throws FOPException{
			return this.fopFactory.newFop(outputFormat, userAgent);
		}

		Fop createFop(OutputStream pdfOutputStream)throws FOPException{
			return this.fopFactory.newFop(MimeConstants.MIME_PDF, this.userAgent, pdfOutputStream);
		}
		
		Fop createFopAreaTree(OutputStream areaTreeOutputStream)throws FOPException{
			return this.fopFactory.newFop(MimeConstants.MIME_FOP_AREA_TREE, this.userAgent, areaTreeOutputStream);
		}

		void execute(InputStream sqsInputStream, String systemId, OutputStream foOutputStream)throws TranslatorException{
			this.xslTranslator.execute(sqsInputStream, systemId, foOutputStream);
		}
	}
	
	private byte[] createFOBytes(byte[] sourceBytes, String systemId) throws TranslatorException, IOException {
		ByteArrayInputStream sqsInputStream = new ByteArrayInputStream(sourceBytes);
		ByteArrayOutputStream foOutputStream = new ByteArrayOutputStream(65536);
		core.execute(sqsInputStream, systemId, foOutputStream);
		sqsInputStream.close();
		sqsInputStream = null;

		foOutputStream.flush();
		byte[] foBytes = foOutputStream.toByteArray();
		foOutputStream.close();
		foOutputStream = null;
		return foBytes;
	}

	private byte[] createSourceBytes(InputStream sourceInputStream) throws IOException {
		ByteArrayOutputStream sourceOutputStream = new ByteArrayOutputStream(4096);

		FileUtil.pipe(sourceInputStream, sourceOutputStream);
		sourceInputStream.close();
		sourceInputStream = null;

		sourceOutputStream.flush();
		byte[] sourceBytes = sourceOutputStream.toByteArray();
		sourceOutputStream.close();
		sourceOutputStream = null;
		return sourceBytes;
	}

	@Override
	public void execute(InputStream sqsSourceInputStream, String systemId, OutputStream pdfOutputStream) throws TranslatorException {
		try {
			byte[] sqsSourceBytes = createSourceBytes(sqsSourceInputStream);
			byte[] foBytes = createFOBytes(sqsSourceBytes, systemId);
			ByteArrayInputStream foInputStream = new ByteArrayInputStream(foBytes);

			/*
			if(DEBUG){
				File tmpFile = File.createTempFile("sqs-pdf",".fo");
				tmpFile.deleteOnExit();
				OutputStream foTest = new BufferedOutputStream(new FileOutputStream(tmpFile));
				FileUtil.connect(foInputStream, foTest);
				foTest.close();
				foInputStream.reset();
			}
			*/
			
			translate(sqsSourceBytes, foInputStream,  pdfOutputStream);
			
		} catch (IOException ex) {
			ex.printStackTrace();
			throw new TranslatorException(ex);
		}
	}

	protected abstract void translate(byte[] sqsSourceBytes, ByteArrayInputStream foInputStream, OutputStream pdfOutputStream)throws TranslatorException;
	
	protected void render(ContentHandler handler, InputStream foInputStream)throws TranslatorException,IOException{
		try{
			//System.out.println("pdfRawDataBytes:"+ pdfRawDataBytes.length);

			// Setup JAXP using identity transformer
			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer transformer = factory.newTransformer();

			// Setup input stream
			Source foInputSource = new StreamSource(foInputStream);

			// Resulting SAX events (the generated FO) must be piped through to FOP
			Result res = new SAXResult(handler);
			// Start XSLT transformation and FO processing
			transformer.transform(foInputSource, res);

		}catch(TransformerException ex){
			ex.printStackTrace();
			throw new TranslatorException(ex);
		}
	}

}