/*

 DataHandler.java

 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2004/10/18

 */
package net.sqs2.editor.httpd;

import java.io.PrintWriter;

import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class DataHandler extends DefaultHandler{
	PrintWriter writer;
	DataHandler(PrintWriter writer){
		this.writer = writer;
	}

	public void startDocument() {
	}

	public void endDocument() {
	}

	public void startElement(String namespaceURI,
			String localName,
			String qName,
			Attributes atts) {
		StringBuffer attstr = new StringBuffer();
		for(int i = 0; i < atts.getLength(); i++){
			String aQName = atts.getQName(i);
			String aValue = atts.getValue(i);
			attstr.append(" ").append(aQName).append("=\"").append(aValue).append("\"");
		}
		writer.print("<"+qName+attstr+">");
	}

	public void endElement(String namespaceURI,
			String localName,
			String qName) {
		writer.print("</"+qName+">");
	}

	public void characters(char[] ch, int start, int length) {
		for (int i = 0; i < length; i++) {
			writer.print(ch[start + i]);
		}
	}

	public void error(SAXParseException ex){
		//System.err.println(ex.getPublicId()+":"+ex.getSystemId()+":"+ex.getLocalizedMessage());
		ex.printStackTrace();
	}

	public void fatalError(SAXParseException ex){
		System.err.println(ex.getPublicId()+":"+ex.getSystemId()+":"+ex.getLocalizedMessage());
		ex.printStackTrace();
	}

	public void warning(SAXParseException ex){
		ex.printStackTrace();
	} 
}

