/*

 SQSEditorResourceFactory.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/03

 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

import javax.swing.Icon;

import net.sf.sqs_xml.editor.base.modules.ContainerEditor;
import net.sf.sqs_xml.editor.base.modules.ContentTextEditor;
import net.sf.sqs_xml.editor.base.modules.EditorUtil;
import net.sf.sqs_xml.editor.base.modules.EmptyEditor;
import net.sf.sqs_xml.editor.base.modules.resource.EditorResource;
import net.sf.sqs_xml.editor.base.swing.EditorResourceFactory;
import net.sf.sqs_xml.editor.sqs.modules.GroupFormEditor;
import net.sf.sqs_xml.editor.sqs.modules.MatrixFormsEditor;
import net.sf.sqs_xml.editor.sqs.modules.MetaEditor;
import net.sf.sqs_xml.editor.sqs.modules.SelectFormColsEditor;
import net.sf.sqs_xml.editor.sqs.modules.SelectFormEditor;
import net.sf.sqs_xml.editor.sqs.modules.TextAreaFormEditor;
import net.sqs2.swing.IconFactory;
import net.sqs2.xmlns.SQSNamespaces;

/**
 * @author hiroya
 *
 */
public class SQSEditorResourceFactory extends EditorResourceFactory{
    Map<String,EditorResource> editorMap;
    
    private static Icon createIcon(String name){
        return IconFactory.create(name); 
    }
    
    private static Icon createIcon(String name, String desc, int overlayTextSize, int overlayTextXOffset){
        return IconFactory.create(name, desc, overlayTextSize, overlayTextXOffset); 
    }
    
    public SQSEditorResourceFactory(){
        this.editorMap = new HashMap<String,EditorResource>();   
        editorMap.put(getKey(null, null),
                new EditorResource(ContentTextEditor.class, createIcon("a.gif"), "文字データ", new Color(210,210,210),
                        36, true, true, EditorUtil.EMPTY_BORDER));
        
        forms();

        structures();
        
        marks();

        matrixForms();


    }
    
    private void matrixForms() {
        editorMap.put(getKey("matrix-forms", SQSNamespaces.SQS2004_URI),
                new EditorResource(MatrixFormsEditor.class, createIcon("matrix-forms.gif"), "設問グループ", new Color(190, 255, 190),
                        400, true, true, EditorUtil.ETCHED_BORDER));

        editorMap.put(getKey("row-array", SQSNamespaces.SQS2004_URI),
                new EditorResource(ContainerEditor.class, createIcon("row-array.gif"), "設問グループの「行」の定義", new Color(190, 255, 190),
                        180, true, false, EditorUtil.ETCHED_BORDER));
        
        editorMap.put(getKey("column-array", SQSNamespaces.SQS2004_URI),
                new EditorResource(ContainerEditor.class, createIcon("column-array.gif"), "設問グループの「列」の定義", new Color(190, 255, 190),
                        180, true, false, EditorUtil.ETCHED_BORDER));
        
        editorMap.put(getKey("group", SQSNamespaces.XFORMS_URI),
                new EditorResource(GroupFormEditor.class, createIcon("box1.gif"), "設問グループの「行」", new Color(150, 225, 150),
                        30, true, true, EditorUtil.ETCHED_BORDER));

        editorMap.put(getKey("input", SQSNamespaces.SQS2004_URI),
                new EditorResource(TextAreaFormEditor.class, createIcon("image1m.gif"), "設問グループ内の自由記述欄", new Color(250,250,200),
                        140, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("textarea", SQSNamespaces.SQS2004_URI),
                new EditorResource(TextAreaFormEditor.class, createIcon("image1m.gif"), "設問グループ内の自由記述欄", new Color(250,250,200),
                        140, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("select", SQSNamespaces.SQS2004_URI),
                new EditorResource(SelectFormEditor.class, createIcon("sphere2m.gif"), "設問グループ内の複数選択式設問", new Color(255,220,240),
                        280, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("select1", SQSNamespaces.SQS2004_URI),
                new EditorResource(SelectFormEditor.class, createIcon("sphere1m.gif"), "設問グループ内の択一選択式設問", new Color(255,230,200),
                        280, true, true, EditorUtil.ETCHED_BORDER));
        

    }

    private void marks() {
        editorMap.put(getKey("mark", SQSNamespaces.SQS2004_URI),
                new EditorResource(EmptyEditor.class, createIcon("mark.gif"), "マーク表記のサンプル  ", new Color(230, 230, 230),
                        30, true, false, EditorUtil.EMPTY_BORDER));
        editorMap.put(getKey("marking-example", SQSNamespaces.SQS2004_URI),
                new EditorResource(EmptyEditor.class, createIcon("marking-example.gif"), "マーク記入例  ", new Color(230, 230, 230),
                        30, true, false, EditorUtil.EMPTY_BORDER));
    }

    private void structures() {
        editorMap.put(getKey("html", SQSNamespaces.XHTML2_URI),
                new EditorResource(ContainerEditor.class, createIcon("sqs-html.gif"), "調査票", new Color(230,230,230),
                        100, true, false, EditorUtil.EMPTY_BORDER));
        editorMap.put(getKey("head", SQSNamespaces.XHTML2_URI),
                new EditorResource(ContainerEditor.class, createIcon("rdf.gif"), "調査票の属性", new Color(230,230,230),
                        100, true, false, EditorUtil.EMPTY_BORDER));
        editorMap.put(getKey("body", SQSNamespaces.XHTML2_URI),
                new EditorResource(ContainerEditor.class, createIcon("body.gif"), "調査票の本文", new Color(230,230,230),
                        100, true, false, EditorUtil.EMPTY_BORDER));
        
        editorMap.put(getKey("title", SQSNamespaces.XHTML2_URI),
                new EditorResource(ContentTextEditor.class, createIcon("folder-cyan.gif", "表題", 12, 0), "調査票の表題", new Color(230,230,255),
                        35, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("meta", SQSNamespaces.XHTML2_URI), 
                new EditorResource(MetaEditor.class, createIcon("rdf-small.gif"), "属性", new Color(230,230,255),
                        55, true, false, EditorUtil.ETCHED_BORDER));
        
        editorMap.put(getKey("section", SQSNamespaces.XHTML2_URI),
                new EditorResource(ContainerEditor.class, createIcon("folder-green.gif", "章", 12, 0), "章", new Color(230, 230, 230),
                        120, true, true, EditorUtil.NORMAL_BORDER));
        editorMap.put(getKey("h", SQSNamespaces.XHTML2_URI),
                new EditorResource(ContentTextEditor.class, createIcon("folder-cyan.gif", "見出し", 10, +1), "見出し", new Color(230, 230, 230),
                        120, true, true, EditorUtil.ETCHED_BORDER));

        editorMap.put(getKey("p", SQSNamespaces.XHTML2_URI),
                new EditorResource(ContentTextEditor.class, createIcon("square-blue.gif"), "段落", new Color(230, 230, 230),
                        50, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("strong", SQSNamespaces.XHTML2_URI),
                new EditorResource(ContentTextEditor.class, createIcon("burst.gif"), "文字データの強調", new Color(230, 230, 230),
                        50, true, true, EditorUtil.ETCHED_BORDER));
        
        editorMap.put(getKey("br", SQSNamespaces.XHTML2_URI),
                new EditorResource(EmptyEditor.class, createIcon("back.gif"), "改行  ", new Color(230, 230, 230),
                        30, true, false, EditorUtil.EMPTY_BORDER));

        editorMap.put(getKey("warning", SQSNamespaces.SQS2004_URI),
                new EditorResource(ContainerEditor.class, createIcon("folder-blue.gif", "注意書", 10, +1), "回答者に対する注意書", new Color(230, 230, 230),
                        30, true, true, EditorUtil.ETCHED_BORDER));
     }

    private void forms() {
        editorMap.put(getKey("input", SQSNamespaces.XFORMS_URI),
                new EditorResource(TextAreaFormEditor.class, createIcon("image1.gif"), "自由記述欄", new Color(250,250,200),
                        140, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("textarea", SQSNamespaces.XFORMS_URI),
                new EditorResource(TextAreaFormEditor.class, createIcon("image1.gif"), "自由記述欄", new Color(250,250,200),
                        140, true, true, EditorUtil.ETCHED_BORDER));

        editorMap.put(getKey("select", SQSNamespaces.XFORMS_URI),
                new EditorResource(SelectFormColsEditor.class, createIcon("sphere2.gif"), "複数選択式設問", new Color(255,220,240),
                        280, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("select1", SQSNamespaces.XFORMS_URI),
                new EditorResource(SelectFormColsEditor.class, createIcon("sphere1.gif"), "択一選択式設問", new Color(255,230,200),
                        280, true, true, EditorUtil.ETCHED_BORDER));
        
        editorMap.put(getKey("item", SQSNamespaces.XFORMS_URI),
                new EditorResource(ContainerEditor.class, createIcon("ball.red.gif"), "選択肢", new Color(230, 230, 230),
                        30, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("label", SQSNamespaces.XFORMS_URI),
                new EditorResource(ContentTextEditor.class, createIcon("right.gif"), "ラベル", new Color(230, 230, 230),
                        30, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("value", SQSNamespaces.XFORMS_URI),
                new EditorResource(ContentTextEditor.class, createIcon("down.gif"), "選択肢の値", new Color(230, 230, 230),
                        30, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("hint", SQSNamespaces.XFORMS_URI),
                new EditorResource(ContentTextEditor.class, createIcon("hand.up.gif"), "設問文", new Color(230, 230, 230),
                        30, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("help", SQSNamespaces.XFORMS_URI),
                new EditorResource(ContentTextEditor.class, createIcon("hand.right.gif"), "設問の補足", new Color(230, 230, 230),
                        30, true, true, EditorUtil.ETCHED_BORDER));
        editorMap.put(getKey("alart", SQSNamespaces.XFORMS_URI),
                new EditorResource(ContentTextEditor.class, createIcon("hand.down.gif"), "設問の注意", new Color(230, 230, 230),
                        30, true, true, EditorUtil.ETCHED_BORDER));
        }

    public EditorResource getEditorResource(String key){
        return (EditorResource)editorMap.get(key);
    }

}
