/*

 MetaDescriptionPanel.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/14

 */
package net.sf.sqs_xml.editor.sqs.modules.panel;
import java.util.HashMap;
import java.util.Map;

import javax.swing.border.TitledBorder;

import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.EditorUtil;
import net.sf.sqs_xml.editor.base.modules.panel.AbstractSingleNodeEditorPanel;



/**
 * @author hiroya
 *
 */
public class MetaDescriptionPanel extends AbstractSingleNodeEditorPanel {
    public static final long serialVersionUID = 0;
    static Map<String,String> map = new HashMap<String,String>();
    static{
        map.put("DC.Title", "タイトル");
        map.put("DC.Title.Short", "タイトル(短縮表記)");
        map.put("DC.Creator", "作成者");
        map.put("DC.Subject", "サブジェクト");
        map.put("DC.Coverage", "調査対象");
        map.put("DCTERMS.Created", "作成日");
        map.put("DCTERMS.Valid", "実施期間");
        map.put("SQS.TemplateID", "テンプレートの識別子");
        //map.put("DCTERMS.Valid", "実施期間");//TODO: MetaData
    }
    
    public MetaDescriptionPanel(AbstractNodeEditor editor){
        super(editor);
        setBorder(new TitledBorder(EditorUtil.LOWERED_BORDER, getDescriptionLabel()));
        initSize();
    }
    
    public String getDescriptionXPath() {
        return "@content";
    }

    public String getDescriptionLabel() {
        return getDescriptionLabel(getEditor().getName());
    }

    public static String getDescriptionLabel(String name) {
        return (String)map.get(name);
    }
    
    public int getPreferredHeight(){
        return 40;
    }
}
