/*
 * ********************************************************************
 * SQLC Release 1.1.0
 * ********************************************************************
 */
package clib.cmd;

import java.sql.*;
import java.io.*;
import java.text.*;

import clib.com.*;
import clib.bean.*;
import clib.cmd.base.*;

/**
 * SystemExec
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class SystemExec extends CommandBase
{
    public boolean end = false;
    /**
     * R}hs
     */
    public boolean execute(ExecuteCtx ctx)
    {
        String command = null;
        String exec_name = null;
        Runtime rt = Runtime.getRuntime();
        try
        {
            command = getCommandString();
            if(command.startsWith("!"))
                exec_name = command.substring(1);
            Process ps = rt.exec(exec_name);

            (new Thread( new SysIn(this,ps.getInputStream(),ctx.comm()) )).start();
            (new Thread( new SysIn(this,ps.getErrorStream(),ctx.comm()) )).start();
            (new Thread( new SysOut(this,ps.getOutputStream(),ctx.comm()) )).start();

            ps.waitFor();
            end = true;
        }
        catch( Exception e )
        {
            System.err.println(e);
        }
        finally
        {
        }
        return true;
    }
}


class SysOut implements Runnable
{
    BufferedReader br   = null;
    PrintWriter    pw   = null;
    CommBean       comm = null;
    SystemExec  exec = null;

    public SysOut(SystemExec exec,OutputStream os,CommBean comm)
    {
        this.comm = comm;
        pw = new PrintWriter( new BufferedWriter( new OutputStreamWriter(os) ), true );
        this.exec = exec;
        br = comm.in();
    }

    public void run()
    {
        try
        {
            String buff;
            while(true)
            {
                if( exec.end ) break;
                if( pw.checkError() ) break;
                if( comm.getInputStream().available() <= 0 ) continue;
System.out.println("BUFF");
                buff = br.readLine();
                pw.println(buff);
            }
        }
        catch(Exception e)
        {
            System.err.println(e);
        }
        return;
    }
}

class SysIn implements Runnable
{
    BufferedReader br = null;
    CommBean       comm = null;
    SystemExec  exec = null;

    public SysIn(SystemExec exec,InputStream is,CommBean comm)
    {
        this.comm = comm;
        br = new BufferedReader( new InputStreamReader(is) );
        this.exec = exec;
    }

    public void run()
    {
        try
        {
            String buff;
            while(true)
            {
                if( exec.end ) break;
                buff = br.readLine();
                if( buff == null ) break;
                comm.println(buff);
            }
        }
        catch(Exception e)
        {
            System.err.println(e);
        }
        return;
    }
}

