/*
 * Decompiled with CFR 0.152.
 */
package clib.bean;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class CommBean {
    protected String name;
    protected InputStream cin;
    protected OutputStream cout;
    protected boolean echo = false;
    protected BufferedReader cbr;
    protected PrintWriter cpw;

    public CommBean() {
    }

    public CommBean(String name) {
        this();
        this.setName(name);
    }

    public CommBean(String name, InputStream cin, OutputStream cout) {
        this(name);
        this.setInputStream(cin);
        this.setOutputStream(cout);
    }

    public CommBean(CommBean obj) {
        this.setInputStream(obj.getInputStream());
        this.setOutputStream(obj.getOutputStream());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setInputStream(InputStream cin) {
        this.cin = cin;
    }

    public InputStream getInputStream() {
        return this.cin;
    }

    public void setOutputStream(OutputStream cout) {
        this.cout = cout;
    }

    public OutputStream getOutputStream() {
        return this.cout;
    }

    public BufferedReader in() {
        return this.cbr;
    }

    public PrintWriter out() {
        return this.cpw;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public boolean getEcho() {
        return this.echo;
    }

    public String readLine() throws IOException {
        String retp = this.in().readLine();
        if (this.echo && retp != null) {
            this.println(retp);
        }
        return retp;
    }

    public void println() {
        this.out().println();
    }

    public void println(String value) {
        this.out().println(value);
    }

    public void print(String value) {
        this.out().print(value);
    }

    public void flush() {
        this.out().flush();
    }

    public void startup() {
        if (this.cpw == null) {
            this.cpw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.cout)), true);
        }
        if (this.cbr == null) {
            this.cbr = new BufferedReader(new InputStreamReader(this.cin));
        }
    }

    public void shutdown() {
    }
}

