/*
 * ********************************************************************
 * SQLC Release 0.6.0
 * ********************************************************************
 */
package clib.com;

import java.io.*;
import java.util.*;

import clib.cmd.*;
import clib.bean.*;
import clib.cmd.base.*;

/**
 * CommandRequest
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class CommandRequest
{
    static Hashtable cmds = null;
    static 
    {
        cmds = new Hashtable();
        cmds.put("HELP",    clib.cmd.Help.class);
        cmds.put("QUIT",    clib.cmd.Quit.class);
        cmds.put("SQL",     clib.cmd.SQL.class);
        cmds.put("NOP",     clib.cmd.Nop.class);
//      cmds.put("HOST",        clib.cmd.CmdSystemExec.class);
//      cmds.put("!",           clib.cmd.CmdSystemExec.class);
        cmds.put("EXECF",   clib.cmd.ExecF.class);
        cmds.put("IMPORT",  clib.cmd.Imp.class);

        cmds.put("HELP",        clib.cmd.Help.class);
        cmds.put("EXIT",        clib.cmd.Quit.class);
        cmds.put("SET",         clib.cmd.Nop.class);
        cmds.put("PROMPT",      clib.cmd.Nop.class);
        cmds.put("@",           clib.cmd.ExecF.class);
    }

    static public CommandBase cinput(CommBean comm,String prompt)
    {
        CommandBase cmd = null;
        String command_string = null;
        String command_name,command_option;
        try
        {
            command_string = readLine(comm,prompt);
            if( command_string == null ) command_string = "QUIT";
            command_string = command_string.trim();
            if( command_string.length() <= 0 )
            {
                cmd = new Nop();
            }
            else
            {
                for(Enumeration i=cmds.keys();i.hasMoreElements();)
                {
                    command_name = (String)i.nextElement();
                    if( command_string.toUpperCase().startsWith(command_name) )
                    {
                        cmd = (CommandBase)((Class)cmds.get(command_name)).newInstance();
                        break;
                    }
                }
            }
            // ȂꍇASQLR}h
            if( cmd == null )
                    cmd = (CommandBase)((Class)cmds.get("SQL")).newInstance();
            if( cmd != null ) cmd.setCommandString(command_string);
        }
        catch(Exception e)
        {
            System.out.println(e);
            e.printStackTrace();
        }
        return cmd;
    }

    static public String readLine(CommBean comm,String prompt)
    {
        String retp;
        int    idx;
        try
        {
            comm.out().print(prompt); comm.out().flush();
            retp = comm.readLine();
            if( retp == null ) comm.out().println();
            if( retp != null )
            {
                if( (idx = retp.indexOf("--"))>=0 )
                {
                    retp = retp.substring(0,idx);
                }
                retp = retp.trim();
            }
        }
        catch(IOException e)
        {
            retp = null;
        }
        return retp;
    }
}
