/*
 * ********************************************************************
 * SQLC Release 0.5.0
 * ********************************************************************
 */
package clib.bean;

import java.io.*;
import java.sql.*;

/**
 * DBڑZbV
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class ConnBean
{
    final static String DEFAULT_CONNECTION_STRING = "jdbc:odbc:LocalServer";

    /** ZbV */
    protected  String       name = null;
    /** ڑ */
    protected  String connection_string = null;
    /** pҖ */
    protected  String user_name    = null;
    /** pX[h */
    protected  String pass_word    = null;
    /** DBڑ */
    protected  Connection   conn   = null;
    /** SQLs */
    protected  Statement    stmt   = null;

    /*******************************************************************
     * \z
     ******************************************************************/
    public ConnBean()
    {
    }

    /*******************************************************************
     * \z
     * @param obj      DBڑ
     ******************************************************************/
    public ConnBean(ConnBean obj)
    {
    }

    /*******************************************************************
     * \z
     * @param name      ZbV
     ******************************************************************/
    public ConnBean(String name)
    {
        this();
        setName(name);
    }

    /*******************************************************************
     * \z
     * @param name      ZbV
     * @param connect_string ڑ
     * @param user_name      pҖ
     * @param pass_word      pX[h
     ******************************************************************/
    public ConnBean(String name,String connection_string, String user_name, String pass_word)
    {
        this(name);
        setConnectionString(connection_string);
        setUserName(user_name);
        setPassWord(pass_word);
    }

    /*******************************************************************
     * ZbVݒ
     * @param name      ZbV
     ******************************************************************/
    public void setName(String name)
    {
        this.name = name;
    }
    /*******************************************************************
     * ZbV擾
     * @return ZbV
     ******************************************************************/
    public String getName()
    {
        return name;
    }


    /*******************************************************************
     * ڑ̐ݒ
     * @param   connection_string ڑ
     ******************************************************************/
    public void setConnectionString(String connection_string)
    {
        this.connection_string = connection_string;
    }
    /*******************************************************************
     * ڑ̎擾
     * @return  ڑ
     ******************************************************************/
    public String getConnectionString()
    {
        return connection_string;
    }

    /*******************************************************************
     * pҖ̐ݒ
     * @param   user_name pҖ
     ******************************************************************/
    public void setUserName(String user_name)
    {
        this.user_name = user_name;
    }
    /*******************************************************************
     * ڑ̎擾
     * @return  ڑ
     ******************************************************************/
    public String getUserName()
    {
        return user_name;
    }

    /*******************************************************************
     * pҖ̐ݒ
     * @param   user_name pҖ
     ******************************************************************/
    public void setPassWord(String pass_word)
    {
        this.pass_word = pass_word;
    }
    /*******************************************************************
     * pҖ̎擾
     * @return  pҖ
     ******************************************************************/
    public String getPassWord()
    {
        return pass_word;
    }

    /*******************************************************************
     * DBڑ擾
     * @return DBڑ
     ******************************************************************/
    public Connection getConnection()
    {
        return conn;
    }

    /*******************************************************************
     * SQLs擾
     * @return SQLs
     ******************************************************************/
    public Statement getStatement() throws SQLException
    {
        if( stmt == null )
        {
            stmt = getConnection().createStatement();
        }
        return stmt;
    }

    /*******************************************************************
     * DBڑq̐ݒ
     * @param   connection_info DBڑq
     ******************************************************************/
    public void setConnectionInfo(String connection_info)
    {
        String user_name = "";
        String pass_word = "";
        String connection_string = connection_info;

        int idx;
        if( (idx = connection_string.indexOf('/')) >= 0 )
        {
            user_name = connection_string.substring(0,idx);
            connection_string = connection_string.substring(idx+1);
            if( (idx = connection_string.indexOf('@')) >= 0 )
            {
                pass_word = connection_string.substring(0,idx);
                connection_string = connection_string.substring(idx+1);
            }
        }

        setUserName(user_name);
        setPassWord(pass_word);
        setConnectionString(connection_string);
        setName(connection_info);
    }

    /*******************************************************************
     * DBւ̐ڑJn
     * @param   comm bZbV
     * @exception SQLException SQLException
     ******************************************************************/
    public void startup(CommBean comm) throws SQLException
    {
        try
        {
            conn = DriverManager.getConnection( connection_string , user_name, pass_word );
            comm.println( "Connect Database \"" + connection_string  + "\"" );
        }
        catch(SQLException e)
        {
            comm.println( "Connect Database \"" + connection_string  + "\" Error" );
            throw e;
        }
        return;
    }

    /*******************************************************************
     * DBւ̐ڑI
     ******************************************************************/
    public void shutdown()
    {
        try
        {
            if( stmt != null ) stmt.close();  stmt = null;
            if( conn != null ) conn.close();  conn = null;
        }
        catch( Exception e )
        {
            System.err.println(e);
            e.printStackTrace();
        }
        return;
    }

    /*******************************************************************
     * DBڑq̐ݒ(b)
     * @param   comm bZbV
     ******************************************************************/
    public void cinput(CommBean comm) throws IOException
    {
        String connect_info;
        String user_name,pass_word;
        comm.print("ConnectionString [" + DEFAULT_CONNECTION_STRING + "]: "); comm.flush(); connect_info = comm.readLine();
        if( connect_info.length() <= 0 ) connect_info = DEFAULT_CONNECTION_STRING;
        comm.print("UserName: "); comm.flush(); user_name = comm.readLine();
        comm.print("PassWord: "); comm.flush(); pass_word = comm.readLine();
        setConnectionString(connect_info);
        setUserName(user_name);
        setPassWord(pass_word);
        setName(user_name+"/"+pass_word+"@"+connect_info);
    }
}
