/*
 * ********************************************************************
 * SQLC Release 0.5.0
 * ********************************************************************
 */
package clib.bean;

import java.io.*;

/**
 * bZbV
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class CommBean
{
    /** ZbV */
    protected  String       name = null;
    /** ͏ */
    protected  InputStream  cin  = null;
    /** o͏ */
    protected  OutputStream cout = null;
    /** GR[ */
    protected  boolean      echo = false;

    /** BufferedReader */
    protected  BufferedReader cbr = null;
    /** PrintWriter */
    protected  PrintWriter    cpw = null;

    /*******************************************************************
     * \z
     ******************************************************************/
    public CommBean()
    {
    }

    /*******************************************************************
     * \z
     * @param name      ZbV
     ******************************************************************/
    public CommBean(String name)
    {
        this();
        setName(name);
    }

    /*******************************************************************
     * \z
     * @param name      ZbV
     * @param cin       ͏
     * @param cout      o͏
     ******************************************************************/
    public CommBean(String name,InputStream cin, OutputStream cout)
    {
        this(name);
        setInputStream(cin);
        setOutputStream(cout);
    }

    /*******************************************************************
     * \z
     * @param obj      bZbV
     ******************************************************************/
    public CommBean(CommBean obj)
    {
        setInputStream(obj.getInputStream());
        setOutputStream(obj.getOutputStream());
    }

    /*******************************************************************
     * ZbVݒ
     * @param name      ZbV
     ******************************************************************/
    public void setName(String name)
    {
        this.name = name;
    }
    /*******************************************************************
     * ZbV擾
     * @return ZbV
     ******************************************************************/
    public String getName()
    {
        return name;
    }

    /*******************************************************************
     * ͏ݒ
     * @param in      ͏
     ******************************************************************/
    public void setInputStream(InputStream cin)
    {
        this.cin = cin;
    }
    /*******************************************************************
     * ͏擾
     * @return ͏
     ******************************************************************/
    public InputStream getInputStream()
    {
        return cin;
    }

    /*******************************************************************
     * o͏ݒ
     * @param in      o͏
     ******************************************************************/
    public void setOutputStream(OutputStream cout)
    {
        this.cout = cout;
    }
    /*******************************************************************
     * o͏擾
     * @return o͏
     ******************************************************************/
    public OutputStream getOutputStream()
    {
        return cout;
    }

    /*******************************************************************
     * ͏擾
     * @return ͏
     ******************************************************************/
    public BufferedReader in()
    {
        return cbr;
    }

    /*******************************************************************
     * o͏擾
     * @return o͏
     ******************************************************************/
    public PrintWriter out()
    {
        return cpw;
    }

    /*******************************************************************
     * GR[ݒ
     * @param in      GR[
     ******************************************************************/
    public void setEcho(boolean echo)
    {
        this.echo = echo;
    }
    /*******************************************************************
     * GR[擾
     * @return GR[
     ******************************************************************/
    public boolean getEcho()
    {
        return echo;
    }

    /*******************************************************************
     * ̓
     * @return ͕
     * @exceptio IOException O
     ******************************************************************/
    public String readLine() throws IOException
    {
        String retp = in().readLine();
        if( echo && retp != null ) println(retp);
        return retp;
    }

    /*******************************************************************
     * ̏o
     ******************************************************************/
    public void println()
    {
        out().println();
    }

    /*******************************************************************
     * ̏o
     * @param value o͕
     ******************************************************************/
    public void println(String value)
    {
        out().println(value);
    }

    /*******************************************************************
     * ̏o
     * @param value o͕
     ******************************************************************/
    public void print(String value)
    {
        out().print(value);
    }

    /*******************************************************************
     * obt@o
     ******************************************************************/
    public void flush()
    {
        out().flush();
    }

    /*******************************************************************
     * bZbVJn
     ******************************************************************/
    public void startup()
    {
        if( cpw == null ) cpw = new PrintWriter( new BufferedWriter( new OutputStreamWriter(cout) ), true );
        if( cbr == null ) cbr = new BufferedReader( new InputStreamReader(cin) );
        return;
    }

    /*******************************************************************
     * bZbVI
     ******************************************************************/
    public void shutdown()
    {
//      try{ if( cin != System.in ) cin.close() } catch( Exception e) {}
//      try{ if( cout != System.out ) cout.close() } catch( Exception e) {}
    }
}
