/*
 * ********************************************************************
 * SQLC Release 0.2.1
 * ********************************************************************
 */
package clib.com;

import java.io.*;
import java.util.*;
import java.sql.*;
import java.text.*;

/**
 * ConnectionCtx
 *
 * @version   1.0
 * @since     JDK1.1
 * @author    dynaworks
 */
public class ConnectionCtx
{
    final static String DEFAULT_CONNECT_NAME = "jdbc:odbc:LocalServer";

    /** ڑ */
    protected  String connection_string = null;
    /** pҖ */
    protected  String user_name    = null;
    /** pX[h */
    protected  String pass_word    = null;
    /** f[^x[Xڑ */
    protected  Connection   conn   = null;
    protected  Statement    stmt   = null;

    /**
     * \z
     */
    public ConnectionCtx()
    {
    }

    /**
     * \z
     * @param bean      bean
     */
    public ConnectionCtx(ConnectionCtx bean)
    {
    }

    /**
     * \z
     * @param connect_string ڑ
     * @param user_name      pҖ
     * @param pass_word      pX[h
     */
    public ConnectionCtx(String connection_string, String user_name, String pass_word)
    {
        this.connection_string = connection_string;
        this.user_name = user_name;
        this.pass_word = pass_word;
    }

    public void setConnectionString(String connection_string)
    {
        this.connection_string = connection_string;
    }
    public void setUserName(String user_name)
    {
        this.user_name = user_name;
    }
    public void setPassWord(String pass_word)
    {
        this.pass_word = pass_word;
    }

    /**
     * ڑ擾B
     * @param connect_string ڑ
     * @param user_name      pҖ
     * @param pass_word      pX[h
     * @return ڑ
     */
    public Connection getConnection()
    {
        return conn;
    }

    public Statement getStatement() throws SQLException
    {
        if( stmt == null )
        {
            stmt = getConnection().createStatement();
        }
        return stmt;
    }

    public void setConnectionInfo(String connection_info)
    {
        String user_name = "";
        String pass_word = "";
        String connection_string = connection_info;

        int idx;
        if( (idx = connection_string.indexOf('/')) >= 0 )
        {
            user_name = connection_string.substring(0,idx);
            connection_string = connection_string.substring(idx+1);
            if( (idx = connection_string.indexOf('@')) >= 0 )
            {
                pass_word = connection_string.substring(0,idx);
                connection_string = connection_string.substring(idx+1);
            }
        }

        setUserName(user_name);
        setPassWord(pass_word);
        setConnectionString(connection_string);
    }

    public void startup(CommCtx comm) throws SQLException
    {
        try
        {
            conn = DriverManager.getConnection( connection_string , user_name, pass_word );
            comm.out().println( "Connect Database \"" + connection_string  + "\"" );
        }
        catch(SQLException e)
        {
            comm.out().println( "Connect Database \"" + connection_string  + "\" Error" );
            throw e;
        }
        return;
    }

    public void shutdown()
    {
        try
        {
            if( stmt != null ) stmt.close();  stmt = null;
            if( conn != null ) conn.close();  conn = null;
        }
        catch( Exception e )
        {
            System.err.println(e);
            e.printStackTrace();
        }
        return;
    }

    public void cinput(CommCtx comm) throws IOException
    {
        String connect_info;
        String user_name,pass_word;
        comm.out().print("ConnectionString [" + DEFAULT_CONNECT_NAME + "]: "); comm.out().flush(); connect_info = comm.in().readLine();
        if( connect_info.length() <= 0 ) connect_info = DEFAULT_CONNECT_NAME;
        comm.out().print("UserName: "); comm.out().flush(); user_name = comm.in().readLine();
        comm.out().print("PassWord: "); comm.out().flush(); pass_word = comm.in().readLine();
        setConnectionString(connect_info);
        setUserName(user_name);
        setPassWord(pass_word);
    }
}
