/*
 * ********************************************************************
 * SQLC Release 0.2.1
 * ********************************************************************
 */
package clib.com;

import java.io.*;
import java.util.*;
import java.sql.*;
import java.text.*;

import clib.cmd.*;

/**
 * CommandRequest
 *
 * @version   1.0
 * @since     JDK1.1
 * @author    dynaworks
 */
public class CommandRequest
{
    static Hashtable cmds = null;
    static CmdDefault   default_cmd = new CmdDefault();
    static 
    {
        cmds = new Hashtable();
        cmds.put("HELP",clib.cmd.CmdShowHelp.class);
        cmds.put("EXIT",clib.cmd.CmdQuit.class);
        cmds.put("QUIT",clib.cmd.CmdQuit.class);
        cmds.put("SQL",clib.cmd.CmdSQLExec.class);
//      cmds.put("HOST",clib.com.CmdSystemExec.class);
//      cmds.put("@",clib.com.CmdSQLFileExec.class);
    }

    static public CommandBase cinput(CommCtx comm,String prompt)
    {
        CommandBase cmd = null;
        String command_string = null;
        String command_name;
        try
        {
            command_string = readLine(comm,prompt);
            if( command_string == null ) command_string = "QUIT";
            if( command_string.length() <= 0 )
            {
                cmd = new CmdDefault(default_cmd);
                cmd.setNop(true);
                return cmd;
            }
            for(Enumeration i=cmds.keys();i.hasMoreElements();)
            {
                command_name = (String)i.nextElement();
                if( command_string.toUpperCase().startsWith(command_name) )
                {
                    cmd = (CommandBase)((Class)cmds.get(command_name)).newInstance();
                    break;
                }
            }
            // ȂꍇASQLR}h
            if( cmd == null )
                    cmd = (CommandBase)((Class)cmds.get("SQL")).newInstance();
            if( cmd != null ) cmd.setCommandString(command_string);
        }
        catch(Exception e)
        {
            System.out.println(e);
            e.printStackTrace();
        }
        return cmd;
    }

    static public String readLine(CommCtx comm,String prompt)
    {
        String retp;
        try
        {
            comm.out().print(prompt); comm.out().flush();
            retp = comm.in().readLine();
            if( retp != null )
                retp = retp.trim();
        }
        catch(IOException e)
        {
            retp = null;
        }
        return retp;
    }
}
