/*
 * Decompiled with CFR 0.152.
 */
package clib.com;

import clib.com.CommCtx;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class DriverLoader {
    Vector drivers = new Vector();
    Vector loaded_drivers = new Vector();
    static final String DEFAULT_DRIVER_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";

    public void addDriver(String driver_name) {
        if (driver_name != null && driver_name.length() > 0 && !this.drivers.contains(driver_name)) {
            this.drivers.addElement(driver_name);
        }
    }

    public void cinput(CommCtx comm) throws IOException {
        comm.out().print("JDBCDriver [sun.jdbc.odbc.JdbcOdbcDriver]: ");
        comm.out().flush();
        String driver_name = comm.in().readLine();
        if (driver_name.length() <= 0) {
            driver_name = DEFAULT_DRIVER_NAME;
        }
        this.addDriver(driver_name);
    }

    public void cload(CommCtx comm) throws Exception {
        Enumeration i = this.drivers.elements();
        while (i.hasMoreElements()) {
            String driver_name = (String)i.nextElement();
            if (this.loaded_drivers.contains(driver_name)) continue;
            try {
                Class.forName(driver_name);
                comm.out().println("Load JDBCDriver \"" + driver_name + "\"");
                this.loaded_drivers.addElement(driver_name);
            }
            catch (ClassNotFoundException e) {
                comm.out().println("JDBCDriver \"" + driver_name + "\" NotFound");
                System.out.println(e);
                e.printStackTrace();
            }
        }
    }
}

