/*
 * ********************************************************************
 * SQL-J
 * ====================================================================
 * RELEASE,DATE,REMARK
 * --------------------------------------------------------------------
 * 0.1.0,2003/09/20
 * 0.2.0,2003/09/27
 * ********************************************************************
 */

import java.io.*;
import java.util.*;
import java.sql.*;
import java.text.*;

/**
 * sqlj
 *
 * @version   0.2.0
 * @since     JDK1.1
 * @author    dynaworks
 */
public class sqlj
{
    final static String logo = "SQL-J Release 0.2.0";
    final static String help = " > java sqlj [-DRV:JDBCDriverName] [-CONN:UserName/PassWord@ConnectionString]";

    final static String DEFAULT_DRIVER_NAME  = "sun.jdbc.odbc.JdbcOdbcDriver";
    final static String DEFAULT_CONNECT_NAME = "jdbc:odbc:LocalServer";

    // *********************************
    // R}hCIvV
    // *********************************
    final static String OPTION_CONNECT_STR       = "CONN";
    final static String OPTION_DRIVER_STR        = "DRV";
    final static char   SWITCH_CHAR              = '-';
    final static char   VALUE_CHAR               = ':';

    // hCo
    static  String driver_name  = null;
    //static  String driver_names[]  = null;

    // *********************************
    // ڑ DBConnectInfo
    // *********************************
    // ڑ
    static  String connect_name = null;
    static  String user_name    = null;
    static  String pass_word    = null;
    static  Connection   conn    = null;
    // *********************************

    static DecimalFormat sqlprompt = new DecimalFormat("##0> ");

    static public void  main(String[] argv)
    {
        Statement    stmt    = null;

        BufferedReader br = null;
        PrintWriter    pw = null;

        try
        {
// ********************************************************************
// 
// ********************************************************************
            br = new BufferedReader( new InputStreamReader(System.in) );
            pw = new PrintWriter( new BufferedWriter( new OutputStreamWriter(System.out) ), true );
            pw.println( logo );

            // **********************************
            // R}hC
            // **********************************
            Hashtable opts = getCommandLineOptions(argv);
            // hCo
            driver_name = (String)opts.get(OPTION_DRIVER_STR);
            // ڑ
            connect_name = (String)opts.get(OPTION_CONNECT_STR);
            if( connect_name != null )
                getDBConnectInfo(connect_name);

            // **********************************
            // caڑ𓾂
            // **********************************
            String driver_names[] = DriverGetNames(pw,br);
            DriverLoad(driver_names,pw);

            if( connect_name == null )
            {
                pw.print("ConnectionString [" + DEFAULT_CONNECT_NAME + "]: "); pw.flush(); connect_name = br.readLine();
                if( connect_name.length() <= 0 ) connect_name = DEFAULT_CONNECT_NAME;
                pw.print("UserName: "); pw.flush(); user_name = br.readLine();
                pw.print("PassWord: "); pw.flush(); pass_word = br.readLine();
            }
            conn = DriverManager.getConnection( connect_name , user_name, pass_word );
            stmt = conn.createStatement();
            pw.println( "Connect Database \"" + connect_name  + "\"" );

// ********************************************************************
// R}h̎s
// ********************************************************************
            String command_line = null;
            boolean fret = true;
            while( fret )
            {
                // ****************************************************
                // R}h
                // ****************************************************
                command_line = getCommand(br,pw,"SQLJ> ");
                if( command_line == null ) break;
                command_line = command_line.trim();
                if( command_line.length() <= 0 ) continue;

                // ****************************************************
                // R}hs
                // ****************************************************
                fret = executeCommand(command_line,br,pw,stmt);
            }
        }
        catch( Exception e )
        {
            System.out.println(e);
            e.printStackTrace();
        }
// ********************************************************************
// ㏈
// ********************************************************************
        finally
        {
            try
            {
                if( stmt != null ) stmt.close();  stmt = null;
                if( conn != null ) conn.close();  conn = null;
            }
            catch( Exception e )
            {
                System.out.println(e);
                e.printStackTrace();
            }
            pw.println( "Good Bye!!" );
        }
        return;
    }

    /**
     * wv\
     */
    static public void showHelp()
    {
        System.out.println(logo);
    }

    static public String getCommand(BufferedReader br,PrintWriter pw, String prompt)
    {
        String retp;
        try
        {
            if( pw != null )
            {
                pw.print(prompt); pw.flush();
            }
            retp = br.readLine();
        }
        catch(IOException e)
        {
            retp = null;
        }
        return retp;
    }

    /**
     * R}hs
     */
    static public boolean executeCommand(String command_line, BufferedReader br,PrintWriter pw,Statement stmt)
    {
        ResultSet    rs      = null;

        String sql = null;
        // ****************************************************
        // I
        // ****************************************************
        if( command_line.toUpperCase().equals("QUIT") || command_line.toUpperCase().equals("EXIT") ) return false;

        // ****************************************************
        // wv
        // ****************************************************
        if( command_line.toUpperCase().equals("HELP") )
        {
            showHelp();
        }
        // ****************************************************
        // eR}h
        // ****************************************************
        else if( command_line.toUpperCase().startsWith("!") )
        {
        }
        // ****************************************************
        // rpk̎s
        // ****************************************************
        else
        {
            try
            {
                String   text;
                int      cols;
                int      res;
                sql = command_line;
                if( sql.indexOf(";") < 0 )
                {
                    int i = 1,j;
                    while( true )
                    {
                        i++;
                        StringBuffer buf = new StringBuffer(sqlprompt.format(i));
                        j = buf.length();
                        for(;j<6;j++) buf = buf.insert(0, ' ');
                        command_line = getCommand(br,pw,buf.toString());
                        if( command_line == null ) break;
                        sql = sql + " " + command_line;
                        if(command_line.indexOf(";") >= 0) break;
                    }
                    sql = sql + " " + command_line;
                }
                if( sql.indexOf(";") >= 0 )
                    sql = sql.substring(0,sql.indexOf(";"));

                stmt.clearWarnings();
                if( sql.toUpperCase().startsWith("SELECT") )
                {
                    ResultSetMetaData rsmd = null;

                    rs = stmt.executeQuery(sql);
                    rsmd = rs.getMetaData();
                    cols = rsmd.getColumnCount();
                    for(int i=1;i<=cols;i++)
                    {
                        text = rsmd.getColumnName(i);
                        if( i != 1 ) pw.print(",");
                        if( text != null ) pw.print(text);
                    }
                    pw.println();

                    res = 0;
                    while( rs.next() )
                    {
                        res = res + 1;
                        for(int i=1;i<=cols;i++)
                        {
                            text = rs.getString(i);
                            if( i != 1 ) pw.print(",");
                            if( text != null ) pw.print(text);
                        }
                        pw.println();
                    }
                    pw.println( "select " + res + " rows." );
                }
                else
                {
                    res = stmt.executeUpdate( sql );
                    pw.println( "update " + res + " rows." );
                }
            }
            catch( SQLException e )
            {
                System.err.println(e);
            }
            finally
            {
                try
                {
                    if( rs != null ) rs.close();  rs = null;
                }
                catch( Exception e )
                {
                    System.out.println(e);
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    static public void getDBConnectInfo(String connect_info)
    {
        user_name = "";
        pass_word = "";
        connect_name = connect_info;

        int idx;
        if( (idx = connect_name.indexOf('/')) >= 0 )
        {
            user_name = connect_name.substring(0,idx);
            connect_name = connect_name.substring(idx+1);
            if( (idx = connect_name.indexOf('@')) >= 0 )
            {
                pass_word = connect_name.substring(0,idx);
                connect_name = connect_name.substring(idx+1);
            }
        }
    }

    static public Hashtable getCommandLineOptions(String[] argv)
    {
        Hashtable opts = new Hashtable();
        String option_name;
        String option_value;
        for(int i=0;i<argv.length;i++)
        {
            option_name = argv[i];
            option_value = "";
            if( option_name.charAt(0) == SWITCH_CHAR )
            {
                option_name = option_name.substring(1);
                int idx = option_name.indexOf(VALUE_CHAR);
                if( idx >= 0 )
                {
                    option_value = option_name.substring(idx+1);
                    option_name = option_name.substring(0,idx);
                }
            }
            opts.put(option_name,option_value);
        }
        return opts;
    }

    static public String[] DriverGetNames(PrintWriter pw,BufferedReader br) throws IOException
    {
        String retp[] = new String[1];
        if( driver_name == null )
        {
            pw.print("JDBCDriver [" + DEFAULT_DRIVER_NAME + "]: "); pw.flush(); driver_name = br.readLine();
            if( driver_name.length() <= 0 ) driver_name = DEFAULT_DRIVER_NAME;
        }
        retp[0] = driver_name;
        return retp;
    }

    static public void DriverLoad(String[] driver_names,PrintWriter pw)
    {
        String driver_name;
        for(int i=0;i<driver_names.length;i++)
        {
            try
            {
                driver_name = driver_names[i];
                Class.forName(driver_name);
                pw.println( "Load JDBCDriver \"" + driver_names[i] + "\"" );
            }
            catch(ClassNotFoundException e)
            {
                pw.println( "JDBCDriver \"" + driver_names[i] + "\" NotFound" );
            }
        }
    }
}


