package clib.cmd;

import java.io.*;

import clib.com.*;
import clib.bean.*;
import clib.cmd.base.*;

/**
 * ExecF
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class ExecF extends CommandBase
{
    /**
     * R}hs
     */
    public boolean execute(ExecuteCtx ctx)
    {
        InputStream is = null;
        try
        {
            String  fname = "";
            String  command = "";
            String  fenc = null;
            int     idx = 0;
            command = getCommandString();
            if( command.startsWith("@") )
                fname = command.substring(1);
            else if( command.startsWith("@@") )
                fname = command.substring(2);

            if( (idx = fname.indexOf("ENC=")) >= 0 )
            {
                fenc=fname.substring(idx+4);
                fname=fname.substring(0,idx);
                fname=fname.trim();
            }
            is = new FileInputStream(new File(fname));
            ctx.createComm(this,ctx.getCommName() + "/" + fname,is,ctx.comm().getOutputStream());
            ctx.comm().setEcho(true);
            if( fenc != null && fenc.length() > 0 )
                ctx.comm().setInputEncode(fenc);
            ctx.startup();
            CommandSession cmnd = new CommandSession();

            cmnd.execute(ctx);
        }
        catch( Exception e )
        {
            System.err.println(e);
        }
        finally
        {
            ctx.deleteComm(this);
            try {if( is != null ) is.close();} catch(IOException e){}
        }
        return true;
    }
}
