package clib.bean;

import java.io.*;
import java.sql.*;
import java.util.*;

/**
 * DBڑZbVǗ
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class ConnBeanMan
{
    static  int conn_index = 0;
    private Hashtable    ctxs;
    private Vector       ctxs_list;
    private String       current_id;
    static private ConnBeanMan   obj = new ConnBeanMan();

    /*******************************************************************
     * \z
     ******************************************************************/
    private ConnBeanMan()
    {
        ctxs = new Hashtable();
        ctxs_list = new Vector();
        current_id = null;
    }

    /*******************************************************************
     * 擾
     * @return   DBڑZbVǗ
     ******************************************************************/
    static public synchronized ConnBeanMan getInstance()
    {
        return obj;
    }

    /*******************************************************************
     * DBڑZbV̐ݒ
     * @param name      ZbV
     * @param conn_info ڑ
     ******************************************************************/
    public void openCtx(String name,String conn_info) throws SQLException
    {
        ConnBean conn = new ConnBean(name,conn_info);
        conn.startup(CommBeanMan.getInstance().getCurrent());
        setCurrentId(conn.getName());
        addCtx(conn);
    }

    /*******************************************************************
     * DBڑZbV̐ݒ
     * @param name      ZbV
     * @param connect_string ڑ
     * @param user_name      pҖ
     * @param pass_word      pX[h
     ******************************************************************/
    public void openCtx(String name,String connection_string, String user_name, String pass_word) throws SQLException
    {
        ConnBean conn = new ConnBean(name,connection_string,user_name,pass_word);
        conn.startup(CommBeanMan.getInstance().getCurrent());
        setCurrentId(conn.getName());
        addCtx(conn);
    }

    public void setCurrentId(String current_id)
    {
        this.current_id = current_id;
    }

    public String getCurrentId()
    {
        return current_id;
    }

    /*******************************************************************
     * DBڑZbV̐ݒ
     * @param name      ZbV
     * @param cin       ͏
     * @param cout      o͏
     ******************************************************************/
    public void closeCtx(String name)
    {
        removeCtx(name);
    }

    /*******************************************************************
     * DBڑZbV̐ݒ
     * @param   ctx   DBڑZbV
     ******************************************************************/
    public void addCtx(ConnBean ctx)
    {
        ctxs.put(ctx.getName(),ctx);
        ctxs_list.addElement( ctx.getName() );
    }
    /*******************************************************************
     * DBڑZbV̎擾
     * @param   name  DBڑ
     * @return  DBڑZbV
     ******************************************************************/
    public ConnBean getCtx(String name)
    {
        return (ConnBean)ctxs.get(name);
    }

    /*******************************************************************
     * DBڑZbV̍폜
     * @param   name  DBڑ
     * @return  DBڑZbV
     ******************************************************************/
    public ConnBean removeCtx(String name)
    {
        return (ConnBean)ctxs.remove(name);
    }

    /*******************************************************************
     * DBւ̐ڑI
     ******************************************************************/
    public void shutdown()
    {
        try
        {
            for(Enumeration e = ctxs.elements();e.hasMoreElements();) 
            {
                ((ConnBean)e.nextElement()).shutdown();
            }
        }
        catch( Exception e )
        {
            System.err.println(e);
            e.printStackTrace();
        }
        return ;
    }

    /*******************************************************************
     * SDBڑZbV̍폜
     ******************************************************************/
    public void clearCtx()
    {
        ctxs.clear();
        return;
    }

    public Vector getList()
    {
        return ctxs_list;
    }

    final static String DEFAULT_CONNECTION_STRING = "jdbc:odbc:LocalServer";

    public void inputNewConn(CommBean comm, String url, String user_name, String pass_word) throws IOException, SQLException
    {
        if( url == null || url.length()<=0 )
        {
            comm.print("ConnectionString [" + DEFAULT_CONNECTION_STRING + "]: ");
            comm.flush();
            url = comm.readLine();
            if( url.length() <= 0 ) url = DEFAULT_CONNECTION_STRING;
        }
        if( user_name == null || user_name.length()<=0 )
        {
            comm.print("UserName: ");
            comm.flush();
            user_name = comm.readLine();
        }
        if( pass_word == null || pass_word.length()<=0 )
        {
            comm.print("PassWord: ");
            comm.flush();
            pass_word = comm.readLine();
        }
        openCtx(user_name+"@"+url,url,user_name,pass_word);
    }
}
