package clib.bean;

import java.io.*;
import java.sql.*;

/**
 * DBڑZbV
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class ConnBean
{
    /** ZbV */
    protected  String       name = null;
    /** ڑ */
    protected  String       connection_string = null;
    /** pҖ */
    protected  String       user_name    = null;
    /** pX[h */
    protected  String       pass_word    = null;
    /** DBڑ */
    protected  Connection   conn   = null;
    /** SQLs */
    protected  Statement    stmt   = null;

    /**
     * \z
     */
    public ConnBean()
    {
    }

    /**
     * \z
     * @param obj      DBڑ
     */
    public ConnBean(ConnBean obj)
    {
    }

    /**
     * \z
     * @param name      ZbV
     */
    public ConnBean(String name)
    {
        this();
        setName(name);
    }

    /**
     * \z
     * @param name      ZbV
     * @param conn_info ڑ
     */
    public ConnBean(String name, String conn_info)
    {
        this();
        setName(name);
        setConnInfo(conn_info);
    }

    /**
     * \z
     * @param name      ZbV
     * @param connect_string ڑ
     * @param user_name      pҖ
     * @param pass_word      pX[h
     */
    public ConnBean(String name, String connection_string, String user_name, String pass_word)
    {
        this(name);
        setConnectionString(connection_string);
        setUserName(user_name);
        setPassWord(pass_word);
    }

    /**
     * ZbVݒ
     * @param name      ZbV
     */
    protected void setName(String name)
    {
        this.name = name;
    }
    /**
     * ZbV擾
     * @return ZbV
     */
    public String getName()
    {
        return name;
    }

    /**
     * DBڑq̐ݒ
     * @param   conn_info DB
     */
    protected void setConnInfo(String conn_info)
    {
        String user_name = "";
        String pass_word = "";
        String buff = conn_info;

        int idx;
        if( (idx = buff.indexOf('/')) >= 0 )
        {
            user_name = buff.substring(0,idx);
            buff = buff.substring(idx+1);
            if( (idx = buff.indexOf('@')) >= 0 )
            {
                pass_word = buff.substring(0,idx);
                buff = buff.substring(idx+1);
            }
        }

        setUserName(user_name);
        setPassWord(pass_word);
        setConnectionString(buff);
        setName(user_name+"@"+buff);
    }

    /**
     * ڑ̐ݒ
     * @param   connection_string ڑ
     */
    protected void setConnectionString(String connection_string)
    {
        this.connection_string = connection_string;
    }
    /**
     * ڑ̎擾
     * @return  ڑ
     */
    public String getConnectionString()
    {
        return connection_string;
    }

    /**
     * pҖ̐ݒ
     * @param   user_name pҖ
     */
    protected void setUserName(String user_name)
    {
        this.user_name = user_name;
    }
    /**
     * pҖ̎擾
     * @return  pҖ
     */
    public String getUserName()
    {
        return user_name;
    }

    /**
     * pX[h̐ݒ
     * @param   pass_word pX[h
     */
    protected void setPassWord(String pass_word)
    {
        this.pass_word = pass_word;
    }
    /**
     * pX[h̎擾
     * @return  pX[h
     */
    public String getPassWord()
    {
        return pass_word;
    }

    /**
     * DBڑ擾
     * @return DBڑ
     */
    public Connection getConnection()
    {
        return conn;
    }

    /**
     * SQLs擾
     * @return SQLs
     */
    public Statement getStatement() throws SQLException
    {
        if( stmt == null )
        {
            stmt = getConnection().createStatement();
        }
        return stmt;
    }

    /**
     * DBւ̐ڑJn
     * @param   comm bZbV
     * @exception SQLException SQLException
     */
    public void startup(CommBean comm) throws SQLException
    {
        try
        {
            conn = DriverManager.getConnection( connection_string , user_name, pass_word );
            conn.setAutoCommit(false);
            comm.println( "Connect Database \"" + user_name + "@" + connection_string  + "\"" );
        }
        catch(SQLException e)
        {
//          comm.println( "Connect Database \"" + connection_string  + "\"," + user_name + "," + pass_word + " Error" );
            comm.println( "Connect Database \"" + user_name + "@" + connection_string  + "\"" + " Error" );
            throw e;
        }
        return;
    }

    /**
     * DBւ̐ڑI
     */
    public void shutdown()
    {
        try
        {
            if( stmt != null ) stmt.close();  stmt = null;
            if( conn != null ) conn.close();  conn = null;
        }
        catch( Exception e )
        {
            System.err.println(e);
            e.printStackTrace();
        }
        return;
    }
}
