/*
 * Copyright (C) the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ 

import java.io.*;
import java.util.*;
import java.sql.*;

import clib.com.*;
import clib.bean.*;

/**
 * sqlc
 *
 * @version   Release 1.1.0
 * @since     JDK1.1
 * @author    dynaworks
 */
public class sqlc
{
    final static String LOGO = "SQLC Release Release 1.1.0";

    // *********************************
    // R}hCIvV
    // *********************************
    final static String OPTION_CONNECT_STR       = "CONN";
    final static String OPTION_DRIVER_STR        = "DRV";
    final static String OPTION_PROPERTIES_STR    = "PROP";

    final static String OPTION_USER_NAME_STR     = "USER";
    final static String OPTION_PASS_WORD_STR     = "PASS";
    final static String OPTION_URL_STR           = "URL";
    final static String OPTION_CONNECT_INFO_STR  = "CONN";

    final static String DEFAULT_OPTION_PROPERTIES_STR    = "sqlc.properties";

    static CommBeanMan comm_man = CommBeanMan.getInstance();
    static ConnBeanMan conn_man = ConnBeanMan.getInstance();
    static DrvBeanMan  drv_man  = DrvBeanMan.getInstance();

    static Properties  prop = new Properties();

    static ExecuteCtx  ctx      = ExecuteCtx.getInstance();

    static public void  main(String[] argv)
    {
        sqlc sqlcx = new sqlc();
        sqlcx.execute(argv);
    }

    public void execute(String[] argv)
    {
        try
        {
            // ********************************************************
            // 
            // ********************************************************
            // ftHgbZbV\z
            comm_man.openCtx("", System.in, System.out);
            ctx.setCommName("");
            ctx.comm().println( LOGO );

            // **********************************
            // R}hC
            // **********************************
            CommandLineOptions opts = new CommandLineOptions(argv,'-',':');

            // **********************************
            // vpeBt@C̓Ǎ
            // **********************************
            try
            {
                File prop_file = null;
                String prop_file_name;

                prop_file_name = opts.getOptionString(OPTION_PROPERTIES_STR);

                // w肳ꂽt@C
                if( prop_file_name != null && prop_file_name.length() > 0 )
                {
                    prop_file = new File(prop_file_name);
                    if( !prop_file.exists() )
                        prop_file = null;
                }
                // JgfBNg̃t@C
                if( prop_file == null )
                {
                    prop_file = new File(DEFAULT_OPTION_PROPERTIES_STR);
                    if( !prop_file.exists() )
                        prop_file = null;
                }
                // z[fBNg̃t@C
                if( prop_file == null )
                {
                    Properties sp = System.getProperties();
                    String     home = sp.getProperty("user.home");
                    if( home != null ) 
                    {
                        prop_file = new File(home + File.separator + DEFAULT_OPTION_PROPERTIES_STR);
                    }
                    if( !prop_file.exists() )
                        prop_file = null;
                }
                if( prop_file != null )
                {
                    FileInputStream fis = new FileInputStream(prop_file);
                    prop.load(fis);
                    fis.close();
                }
//              prop.list(System.err);
            }
            catch(Exception e)
            {
//              comm.out().println( "ERR: Property File Load" );
//              e.printStackTrace();
            }
            // ********************************************************
            // DBڑ𓾂
            // ********************************************************
            // **********************************
            // JDBChCo̐ݒ
            // **********************************
            String driver_name;
            StringTokenizer st;
            boolean         fLoad;
            // vpeBt@C̏
            fLoad = false;
            driver_name = prop.getProperty(OPTION_DRIVER_STR,"");
            if( driver_name != null && driver_name.length() > 0 )
                drv_man.inputNewBean(ctx.comm(),driver_name);

            driver_name = opts.getOptionString(OPTION_DRIVER_STR);
            if( driver_name != null && driver_name.length() > 0 )
                drv_man.inputNewBean(ctx.comm(),driver_name);

            if( drv_man.getSize() <= 0 )
            {
                drv_man.inputNewBean(ctx.comm(),null);
            }

            // **********************************
            // DBڑݒ
            // **********************************
            String    user_name = "",pass_word = "",connect_info = "",url = "";
            // vpeBt@C̏
            {
                user_name = prop.getProperty(OPTION_USER_NAME_STR,"");
                pass_word = prop.getProperty(OPTION_PASS_WORD_STR,"");
                url = prop.getProperty(OPTION_URL_STR,"");
            }
            // ڑ
            connect_info = opts.getOptionString(OPTION_CONNECT_STR);

            if( !(connect_info == null || connect_info.length()<=0) )
            {
                conn_man.openCtx("",connect_info);
            }
            else
            {
                conn_man.inputNewConn(ctx.comm(),url,user_name,pass_word);
            }

            // DBڑJn
            ctx.setConnName(conn_man.getCurrentId());

            // ********************************************************
            // R}h̎s
            // ********************************************************
            CommandSession cmnd = new CommandSession();
            cmnd.execute(ctx);
        }
        catch( Exception e )
        {
            System.out.println(e);
            e.printStackTrace();
        }
        // ************************************************************
        // ㏈
        // ************************************************************
        finally
        {
            ctx.comm().println( "Good Bye!!" );
        }
        return;
    }
}
