package clib.bean;

import java.io.*;
import java.util.*;

/**
 * DrvBeanMan
 *
 * @since     JDK1.1
 * @author    dynaworks
 */
public class DrvBeanMan
{
    /** WJDBC-DRIVER           */
    final static String DEFAULT_DRIVER_NAME  = "sun.jdbc.odbc.JdbcOdbcDriver";

    /** ǍΏJDBC-DRIVERXg */
    private Vector target_drivers = null;
    /** ǍJDBC-DRIVERXg   */
    private Vector loaded_drivers = null;

    static private DrvBeanMan   obj = new DrvBeanMan();

    /*******************************************************************
     * \z
     ******************************************************************/
    private DrvBeanMan()
    {
//      target_drivers = new Vector();
        loaded_drivers = new Vector();
    }

    /*******************************************************************
     * 擾
     * @return   DBڑZbVǗ
     ******************************************************************/
    static public synchronized DrvBeanMan getInstance()
    {
        return obj;
    }

    /*******************************************************************
     * DBڑZbV̐ݒ
     * @param name      ZbV
     ******************************************************************/
    public boolean openCtx(String driver_name)
    {
        boolean retp = false;
        try
        {
            // TODO dǍ֎~
            Class.forName(driver_name);
            CommBeanMan.getInstance().getCurrent().info("JDBC-Driver \"" + driver_name + "\" Load" );
            loaded_drivers.addElement(driver_name);
            retp = true;
        }
        catch(ClassNotFoundException e)
        {
            CommBeanMan.getInstance().getCurrent().error( "JDBC-Driver \"" + driver_name + "\" NotFound" );
        }
        return retp;
    }

    public int getSize()
    {
        return loaded_drivers.size();
    }

    public void inputNewBean(CommBean comm, String drivers_name) throws IOException
    {
        StringTokenizer st;
        if( drivers_name == null || drivers_name.length() <= 0 )
        {
            comm.print("JDBCDriver [" + DEFAULT_DRIVER_NAME + "]: ");
            comm.flush();
            drivers_name = comm.readLine();
            if( drivers_name.length() <= 0 ) drivers_name = DEFAULT_DRIVER_NAME;
        }

        for(st = new StringTokenizer(drivers_name,",");st.hasMoreTokens();)
        {
            String drv_elem = st.nextToken();
            if( drv_elem != null && !(drv_elem.length() <= 0) )
            {
                openCtx(drv_elem);
            }
        }
    }

}
