/*
 * Decompiled with CFR 0.152.
 */
package clib.com;

import clib.bean.CommBean;
import clib.bean.CommBeanMan;
import clib.bean.ConnBean;
import clib.bean.ConnBeanMan;
import clib.bean.RecOutBean;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class ExecuteCtx {
    private static ExecuteCtx ctx = new ExecuteCtx();
    protected String comm_name = null;
    protected String conn_name = null;
    protected RecOutBean reco;
    protected Hashtable comm_stack = new Hashtable();
    protected Hashtable conn_stack = new Hashtable();

    private ExecuteCtx() {
    }

    public static ExecuteCtx getInstance() {
        return ctx;
    }

    public void setCommConnName(String comm_name, String conn_name) {
        this.setCommName(comm_name);
        this.setConnName(comm_name);
    }

    public String getCommName() {
        return this.comm_name;
    }

    public void setCommName(String comm_name) {
        this.comm_name = comm_name;
    }

    public String getConnName() {
        return this.conn_name;
    }

    public void setConnName(String conn_name) {
        this.conn_name = conn_name;
    }

    public void pushComm(Object id) {
        if (this.comm_name != null) {
            this.comm_stack.put(id.toString(), this.comm_name);
        }
    }

    public boolean popComm(Object id) {
        String name = (String)this.comm_stack.remove(id.toString());
        if (name == null) {
            return false;
        }
        this.setCommName(name);
        return true;
    }

    public CommBean comm() {
        return CommBeanMan.getInstance().getCtx(this.comm_name);
    }

    public void createComm(Object obj, String name, InputStream is, OutputStream os) {
        this.pushComm(obj);
        CommBean comm = new CommBean(name, is, os);
        this.setCommName(name);
        comm.startup();
        CommBeanMan.getInstance().addCtx(comm);
    }

    public void deleteComm(Object obj) {
        String name = this.getCommName();
        if (this.popComm(obj)) {
            CommBeanMan.getInstance().removeCtx(name);
        }
    }

    public void pushConn(Object id) {
        if (this.conn_name != null) {
            this.conn_stack.put(id.toString(), this.conn_name);
        }
    }

    public boolean popConn(Object id) {
        String name = (String)this.conn_stack.remove(id.toString());
        if (name == null) {
            return false;
        }
        this.setConnName(name);
        return true;
    }

    public ConnBean conn() {
        return ConnBeanMan.getInstance().getCtx(this.conn_name);
    }

    public RecOutBean reco() {
        return this.reco;
    }
}

