/*
 * Decompiled with CFR 0.152.
 */
package clib.bean;

import clib.bean.CommBean;
import clib.bean.CommBeanMan;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DrvBeanMan {
    static final String DEFAULT_DRIVER_NAME = "sun.jdbc.odbc.JdbcOdbcDriver";
    private Vector target_drivers;
    private Vector loaded_drivers = new Vector();
    private static DrvBeanMan obj = new DrvBeanMan();

    private DrvBeanMan() {
    }

    public static synchronized DrvBeanMan getInstance() {
        return obj;
    }

    public boolean openCtx(String driver_name) {
        boolean retp = false;
        try {
            Class.forName(driver_name);
            CommBeanMan.getInstance().getCurrent().info("JDBC-Driver \"" + driver_name + "\" Load");
            this.loaded_drivers.addElement(driver_name);
            retp = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            CommBeanMan.getInstance().getCurrent().error("JDBC-Driver \"" + driver_name + "\" NotFound");
        }
        return retp;
    }

    public int getSize() {
        return this.loaded_drivers.size();
    }

    public void inputNewBean(CommBean comm, String drivers_name) throws IOException {
        if (drivers_name == null || drivers_name.length() <= 0) {
            comm.print("JDBCDriver [sun.jdbc.odbc.JdbcOdbcDriver]: ");
            comm.flush();
            drivers_name = comm.readLine();
            if (drivers_name.length() <= 0) {
                drivers_name = DEFAULT_DRIVER_NAME;
            }
        }
        StringTokenizer st = new StringTokenizer(drivers_name, ",");
        while (st.hasMoreTokens()) {
            String drv_elem = st.nextToken();
            if (drv_elem == null || drv_elem.length() <= 0) continue;
            this.openCtx(drv_elem);
        }
    }
}

