package org.sqlite.jdbc;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class JdbcConnectionTest {

    public JdbcConnectionTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";
    
    private static JdbcConnection newConnection() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return (JdbcConnection) DriverManager.getConnection("jdbc:sqlite:file:" + DATABASE);
    }

    @Test
    public void enableFullColumnNames() throws ClassNotFoundException, SQLException {
        final JdbcConnection conn = newConnection();
        try {
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ROWID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", ID INTEGER NOT NULL"
                        + ", tVALUE TEXT DEFAULT '_blank'"
                        + ", rVALUE REAL"
                        + ", bVALUE BLOB"
                        + ", nVALUE NULL"
                        + ", tVALUE2 text DEFAULT ''"
                        + ", tVALUE3 VarChar DEFAULT NULL"
                    + ");"
                    + "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_2("
                        + "  ID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", VALUE TEXT"
                    + ")";
            stmt.execute(sql);
            
            sql = "SELECT * FROM temp_tbl_1 LEFT OUTER JOIN temp_tbl_2 ON temp_tbl_1.ID = temp_tbl_2.ID";
            ResultSet rs = stmt.executeQuery(sql);
            ResultSetMetaData rsMeta = rs.getMetaData();
            assertEquals(10, rsMeta.getColumnCount());
            assertEquals("ROWID", rsMeta.getColumnLabel(1));
            assertEquals("ROWID", rsMeta.getColumnName(1));
            assertEquals("ID", rsMeta.getColumnLabel(2));
            assertEquals("ID", rsMeta.getColumnName(2));
            assertEquals("ID", rsMeta.getColumnLabel(9));
            assertEquals("ID", rsMeta.getColumnName(9));
            assertEquals("VALUE", rsMeta.getColumnLabel(10));
            assertEquals("VALUE", rsMeta.getColumnName(10));
            assertEquals(2, rs.findColumn("ID"));
            rs.close();
            
            stmt.execute(
                    "PRAGMA short_column_names = off;"
                    + "PRAGMA full_column_names = on"
                );
            
            rs = stmt.executeQuery(sql);
            rsMeta = rs.getMetaData();
            assertEquals(10, rsMeta.getColumnCount());
            assertEquals("temp_tbl_1.ROWID", rsMeta.getColumnLabel(1));
            assertEquals("ROWID", rsMeta.getColumnName(1));
            assertEquals("temp_tbl_1.ID", rsMeta.getColumnLabel(2));
            assertEquals("ID", rsMeta.getColumnName(2));
            assertEquals("temp_tbl_2.ID", rsMeta.getColumnLabel(9));
            assertEquals("ID", rsMeta.getColumnName(9));
            assertEquals("temp_tbl_2.VALUE", rsMeta.getColumnLabel(10));
            assertEquals("VALUE", rsMeta.getColumnName(10));
            assertEquals(2, rs.findColumn("temp_tbl_1.ID"));
            assertEquals(9, rs.findColumn("temp_tbl_2.ID"));
            rs.close();
            
        } finally {
            conn.close();
        }
    }
}