/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class DriverTest {

    public DriverTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void getDriverName() {
        assertEquals("SQLite JDBC Driver", Driver.getDriverName());
    }
    
    @Test
    public void getDriverVersion() throws FileNotFoundException, IOException {
        assertEquals(
                Driver.getDriverMajorVersion()
                    + "." + Driver.getDriverMinorVersion()
                    + "." + Driver.getDriverReleaseVersion(),
                Driver.getDriverVersion()
            );
        
        final Properties prop = new Properties();
        prop.load(new FileInputStream("nbproject/project.properties"));
        assertEquals(prop.getProperty("dist.version"),
                Driver.getDriverVersion()
            );
    }
    
    private static Properties newProjectProperties() throws FileNotFoundException, IOException {
        final Properties prop = new Properties();
        prop.load(new FileInputStream("nbproject/project.properties"));
        return prop;
    }
    
    @Test
    public void getDriverMajorVersion() throws FileNotFoundException, IOException {
        final Properties prop = newProjectProperties();
        final String var = prop.getProperty("dist.version").split("\\.")[0];

        assertEquals(Integer.parseInt(var), Driver.getDriverMajorVersion());
    }
    
    @Test
    public void getDriverMinorVersion() throws FileNotFoundException, IOException {
        final Properties prop = newProjectProperties();
        final String var = prop.getProperty("dist.version").split("\\.")[1];

        assertEquals(Integer.parseInt(var), Driver.getDriverMinorVersion());
    }
    
    @Test
    public void getDriverReleaseVersion() throws FileNotFoundException, IOException {
        final Properties prop = newProjectProperties();
        final String var = prop.getProperty("dist.version").split("\\.")[2];

        assertEquals(Integer.parseInt(var), Driver.getDriverReleaseVersion());
    }
    
    private static final String[] ACCEPT_URLs
            = new String[] {
                    "jdbc:sqlite:file:\\My Documents\\mydb.db",
                    "jdbc:sqlite:mem:",
                    "jdbc:sqlite:mem:SAMPLE",
                    "jdbc:sqlite:\\My Documents\\mydb.db",
                };
    
    private static final String[] DENIAL_URLs
            = new String[] {
                    "jdbc:sqlite\\My Documents\\mydb.db",
                    "sqlite:/\\My Documents\\mydb.db",
                };
    
    @Test
    public void acceptsURL() {
        Driver driver = new Driver();

        for (final String url : ACCEPT_URLs) {
            assertTrue(driver.acceptsURL(url));
        }

        for (final String url : DENIAL_URLs) {
            assertFalse(driver.acceptsURL(url));
        }
    }
    
    private static final String[] OPEN_URLs
            = new String[] {
                    "jdbc:sqlite:file:test/unittest.db",
                    "jdbc:sqlite:mem:",
                    "jdbc:sqlite:mem:SAMPLE",
                    "jdbc:sqlite:test/unittest.db",
                };
    
    @Test
    public void connect() throws SQLException {
        Driver driver = new Driver();
        
        Connection conn = null;
        for (final String url : OPEN_URLs) {
            conn = driver.connect(url, null);
            assertNotNull(conn);
            conn.close();
        }

        for (final String url : DENIAL_URLs) {
            conn = driver.connect(url, null);
            assertNull(conn);
        }
    }
    
    private static final String[] NOT_OPEN_URLs
            = new String[] {
                    "jdbc:sqlite:file:\\Program Files",
                };
    
    @Test(expected = java.sql.SQLException.class)
    public void connectThrowSQLException() throws SQLException {
        Driver driver = new Driver();
        
        Connection conn = null;
        for (final String url : NOT_OPEN_URLs) {
            conn = driver.connect(url, null);
            conn.close();
        }
    }
    
    @Test
    public void getMajorVersion() {
        assertEquals(Driver.getDriverMajorVersion(), new Driver().getMajorVersion());
    }
    
    @Test
    public void getMinorVersion() {
        assertEquals(Driver.getDriverMinorVersion(), new Driver().getMinorVersion());
    }
    
    @Test
    public void getPropertyInfo() {
        // TODO do unit test!
    }
    
    @Test
    public void jdbcCompliant() {
        assertFalse(new Driver().jdbcCompliant());
    }
    
}