import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.text.Collator;

public class CollatorExample {

    @org.junit.Test
    public void example() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.Driver");
        final String url = "jdbc:sqlite:mem:";
        final JdbcConnection conn = (JdbcConnection) DriverManager.getConnection(url);
        try {
            // new collation sequence
            final Collator myCollSeq
                    = new Collator("LENGTH") {
                            public int compare(String str1, String str2) {
                                if (str1.length() < str2.length()) {
                                    return -1;
                                } else if (str1.length() > str2.length()) {
                                    return 1;
                                }
                                return 0;
                            }
                        };

            // create collation sequence
            conn.createCollationSequence(myCollSeq);

            final Statement stmt = conn.createStatement();
            final String sql
                    = "SELECT * FROM ("
                        + "SELECT '' AS NUM UNION ALL "
                        + "SELECT 'One' AS NUM UNION ALL "
                        + "SELECT 'Two' AS NUM UNION ALL "
                        + "SELECT 'Three' AS NUM UNION ALL "
                        + "SELECT 'Four' AS NUM UNION ALL "
                        + "SELECT NULL AS NUM UNION ALL "
                        + "SELECT X'5A65726F00' AS NUM "
                    + ") ORDER BY NUM COLLATE LENGTH ASC";

            for (final ResultSet rs = stmt.executeQuery(sql); rs.next(); ) {
                System.out.println(rs.getString(1));
            }
            stmt.close();

            // drop collation sequence
            conn.dropCollationSequence(myCollSeq);

        } finally {
            conn.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new CollatorExample().example();
    }
}
