/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import org.sqlite.Database;
import org.sqlite.io.Closeable;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_blob;

public class Blob
implements Closeable {
    private final Database db;
    private final SQLite3.SQLite3BlobPtrPtr ppBlob;
    private final SWIGTYPE_p_sqlite3_blob blob;
    private boolean isClosed;

    Blob(Database db, SQLite3.SQLite3BlobPtrPtr ppBlob) {
        this.db = db;
        this.ppBlob = ppBlob;
        this.blob = ppBlob.getSQLite3BlobPtr();
        this.isClosed = false;
        db.add(this);
    }

    public boolean isClosed() {
        return this.isClosed || this.db.isClosed();
    }

    public void close() throws SQLException {
        if (!this.isClosed) {
            int ret;
            if (!this.db.isClosed() && (ret = SQLite3.sqlite3_blob_close(this.blob)) != 0) {
                new JdbcSQLException(ret, this.db.getHandle());
            }
            this.isClosed = true;
            this.ppBlob.delete();
            this.db.remove(this);
        }
    }

    public int length() throws SQLException {
        this.validateBlobOpen();
        return SQLite3.sqlite3_blob_bytes(this.blob);
    }

    public void read(byte[] b, int len, int offset) throws SQLException {
        this.validateBlobOpen();
        int ret = SQLite3.sqlite3_blob_read(this.blob, b, len, offset);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.db.getHandle());
        }
    }

    public void write(byte[] b, int len, int offset) throws SQLException {
        this.validateBlobOpen();
        int ret = SQLite3.sqlite3_blob_write(this.blob, b, len, offset);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.db.getHandle());
        }
    }

    private void validateBlobOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Blob is already closed.", "90007");
        }
    }
}

