/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.Database;
import org.sqlite.io.Closeable;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_Mem;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_stmt;
import org.sqlite.swig.SWIGTYPE_p_void;

public class Statement
implements Closeable {
    private final Database db;
    private final SWIGTYPE_p_sqlite3_stmt stmt;
    private final SQLite3.SQLite3StmtPtrPtr ppStmt;
    private boolean isClosed;

    Statement(Database db, SWIGTYPE_p_sqlite3_stmt stmt) throws SQLException {
        this(db, stmt, null);
    }

    Statement(Database db, SQLite3.SQLite3StmtPtrPtr ppStmt) throws SQLException {
        this(db, ppStmt.getSQLite3StmtPtr(), ppStmt);
    }

    private Statement(Database db, SWIGTYPE_p_sqlite3_stmt stmt, SQLite3.SQLite3StmtPtrPtr ppStmt) throws SQLException {
        this.db = db;
        this.stmt = stmt;
        this.ppStmt = ppStmt;
        db.add(this);
    }

    public boolean isManaged() {
        return this.ppStmt == null;
    }

    public int getParameterCount() throws SQLException {
        this.validateStatementOpen();
        return SQLite3.sqlite3_bind_parameter_count(this.stmt);
    }

    public int getParameterIndex(String parameterName) throws SQLException {
        this.validateStatementOpen();
        return SQLite3.sqlite3_bind_parameter_index(this.stmt, parameterName);
    }

    public String getParameterName(int parameterIndex) throws SQLException {
        this.validateStatementOpen();
        String x = SQLite3.sqlite3_bind_parameter_name(this.stmt, parameterIndex);
        this.checkErrorOccurred();
        return x;
    }

    public int getColumnCount() throws SQLException {
        this.validateStatementOpen();
        return SQLite3.sqlite3_column_count(this.stmt);
    }

    public int getDataCount() throws SQLException {
        this.validateStatementOpen();
        return SQLite3.sqlite3_data_count(this.stmt);
    }

    public String getColumnDatabaseName(int columnIndex) throws SQLException {
        this.validateStatementOpen();
        String x = SQLite3.sqlite3_column_database_name(this.stmt, columnIndex - 1);
        this.checkErrorOccurred();
        return x;
    }

    public String getColumnLabel(int columnIndex) throws SQLException {
        this.validateColumnIndexRange(columnIndex);
        return SQLite3.sqlite3_column_name(this.stmt, columnIndex - 1);
    }

    public String getColumnName(int columnIndex) throws SQLException {
        this.validateColumnIndexRange(columnIndex);
        return SQLite3.sqlite3_column_origin_name(this.stmt, columnIndex - 1);
    }

    public int getColumnType(int columnIndex) throws SQLException {
        this.validateStatementOpen();
        int x = SQLite3.sqlite3_column_type(this.stmt, columnIndex - 1);
        this.checkErrorOccurred();
        return x;
    }

    public String getColumnTableName(int columnIndex) throws SQLException {
        this.validateColumnIndexRange(columnIndex);
        return SQLite3.sqlite3_column_table_name(this.stmt, columnIndex - 1);
    }

    public String getColumnTypeName(int columnIndex) throws SQLException {
        this.validateColumnIndexRange(columnIndex);
        return SQLite3.sqlite3_column_decltype(this.stmt, columnIndex - 1);
    }

    public String getString(int columnIndex) throws SQLException {
        this.validateStatementOpen();
        String x = SQLite3.sqlite3_column_text(this.stmt, columnIndex - 1);
        this.checkErrorOccurred();
        return x;
    }

    public int getInt(int columnIndex) throws SQLException {
        this.validateStatementOpen();
        int x = SQLite3.sqlite3_column_int(this.stmt, columnIndex - 1);
        this.checkErrorOccurred();
        return x;
    }

    public long getLong(int columnIndex) throws SQLException {
        this.validateStatementOpen();
        long x = SQLite3.sqlite3_column_int64(this.stmt, columnIndex - 1);
        this.checkErrorOccurred();
        return x;
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.validateStatementOpen();
        double x = SQLite3.sqlite3_column_double(this.stmt, columnIndex - 1);
        this.checkErrorOccurred();
        return x;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.validateStatementOpen();
        byte[] x = SQLite3.sqlite3_column_blob_by_bytes(this.stmt, columnIndex - 1);
        this.checkErrorOccurred();
        return x;
    }

    public SWIGTYPE_p_void getBlob(int columnIndex) throws SQLException {
        this.validateStatementOpen();
        SWIGTYPE_p_void x = SQLite3.sqlite3_column_blob(this.stmt, columnIndex - 1);
        this.checkErrorOccurred();
        return x;
    }

    public int getByteLength(int columnIndex) throws SQLException {
        this.validateStatementOpen();
        int x = SQLite3.sqlite3_column_bytes(this.stmt, columnIndex - 1);
        this.checkErrorOccurred();
        return x;
    }

    public SWIGTYPE_p_Mem getValue(int columnIndex) throws SQLException {
        this.validateStatementOpen();
        SWIGTYPE_p_Mem x = SQLite3.sqlite3_column_value(this.stmt, columnIndex - 1);
        this.checkErrorOccurred();
        return x;
    }

    public void bindNull(int parameterIndex) throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_bind_null(this.stmt, parameterIndex);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public void bindInt(int parameterIndex, int val) throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_bind_int(this.stmt, parameterIndex, val);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public void bindLong(int parameterIndex, long val) throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_bind_int64(this.stmt, parameterIndex, val);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public void bindDouble(int parameterIndex, double val) throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_bind_double(this.stmt, parameterIndex, val);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public void bindText(int parameterIndex, String val) throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_bind_text(this.stmt, parameterIndex, val);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public void bindBytes(int parameterIndex, byte[] val) throws SQLException {
        this.bindBytes(parameterIndex, val, val.length);
    }

    public void bindBytes(int parameterIndex, byte[] val, int len) throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_bind_blob(this.stmt, parameterIndex, val, len);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public void bindValue(int parameterIndex, SWIGTYPE_p_Mem val) throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_bind_value(this.stmt, parameterIndex, val);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public void bindBlob(int parameterIndex, SWIGTYPE_p_void val, int len) throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_bind_blob(this.stmt, parameterIndex, val, len);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public void bindZeroBlob(int parameterIndex, int bytes) throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_bind_zeroblob(this.stmt, parameterIndex, bytes);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public void clearBinding() throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_clear_bindings(this.stmt);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public void reset() throws SQLException {
        this.validateStatementOpen();
        int ret = SQLite3.sqlite3_reset(this.stmt);
        if (ret != 0) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public int step() throws SQLException {
        this.validateStatementOpen();
        int ret = 0;
        while ((ret = SQLite3.sqlite3_step(this.stmt)) == 5 && this.db.getBusyTimeout() == 0) {
        }
        if (ret != 101 && ret != 100) {
            throw new JdbcSQLException(ret, this.stmt);
        }
        return ret;
    }

    public int execute() throws SQLException {
        return this.step();
    }

    public SWIGTYPE_p_sqlite3 getDbHandle() throws SQLException {
        this.validateStatementOpen();
        return SQLite3.sqlite3_db_handle(this.stmt);
    }

    public boolean producedResultSet() throws SQLException {
        return this.getColumnCount() != 0;
    }

    SWIGTYPE_p_sqlite3_stmt getHandle() throws SQLException {
        this.validateStatementOpen();
        return this.stmt;
    }

    public String getSQL() throws SQLException {
        this.validateStatementOpen();
        return SQLite3.sqlite3_sql(this.stmt);
    }

    public boolean isClosed() {
        return this.isClosed || this.db.isClosed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws SQLException {
        if (this.isClosed) return;
        if (!this.db.isClosed()) {
            int ret = SQLite3.sqlite3_finalize(this.stmt);
            if (ret != 0 && this.db.getLastError() != 0) {
                if (ret != 4) throw new JdbcSQLException(ret, this.db.getHandle());
                Logger.getLogger(Statement.class.getName()).info("Transaction aborted.");
            }
        } else {
            Logger.getLogger(Statement.class.getName()).warning("Database connection is already closed.");
        }
        this.isClosed = true;
        this.db.remove(this);
        if (this.ppStmt == null) return;
        this.ppStmt.delete();
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            Logger.getLogger(Statement.class.getName()).info("Statement is not closed.");
            this.close();
        }
        super.finalize();
    }

    protected void validateStatementOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is already closed.", "90007");
        }
    }

    public void validateColumnIndexRange(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
            throw new JdbcSQLException(25);
        }
    }

    private void checkErrorOccurred() throws SQLException {
        int ret = this.db.getLastError();
        if (ret != 0 && ret != 100 && ret != 101) {
            throw new JdbcSQLException(ret, this.stmt);
        }
    }

    public Database getDatabase() throws SQLException {
        this.validateStatementOpen();
        return this.db;
    }
}

