/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.jdbc.Scheme;

public class Driver
implements java.sql.Driver {
    public static String getDriverName() {
        return "SQLite JDBC Driver";
    }

    public static String getDriverVersion() {
        return Driver.getDriverMajorVersion() + "." + Driver.getDriverMinorVersion() + "." + Driver.getDriverReleaseVersion();
    }

    public static int getDriverMajorVersion() {
        return 1;
    }

    public static int getDriverMinorVersion() {
        return 0;
    }

    public static int getDriverReleaseVersion() {
        return 1;
    }

    public boolean acceptsURL(String url) {
        for (Scheme scheme : Scheme.values()) {
            if (!scheme.matches(url)) continue;
            return true;
        }
        return false;
    }

    public JdbcConnection connect(String url, Properties info) throws SQLException {
        for (Scheme scheme : Scheme.values()) {
            Map<String, String> prop = scheme.parse(url);
            if (prop == null) continue;
            String filename = prop.remove(";filename;");
            if (info != null) {
                for (Object obj : info.keySet()) {
                    String key = obj.toString();
                    prop.put(key, info.getProperty(key));
                }
            }
            Database db = new Database(filename, prop.isEmpty() ? null : prop);
            return new JdbcConnection(db, url);
        }
        return null;
    }

    public int getMajorVersion() {
        return Driver.getDriverMajorVersion();
    }

    public int getMinorVersion() {
        return Driver.getDriverMinorVersion();
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[]{new DriverPropertyInfo("TEMP_DIR", ""), new DriverPropertyInfo("READ_ONLY", ""), new DriverPropertyInfo("OPEN_EXIST", ""), new DriverPropertyInfo("VFS", "")};
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            System.loadLibrary("sqlite3jni");
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException ex) {
            Logger.getLogger(Driver.class.getName()).throwing(Driver.class.getName(), "<clinit>", ex);
            throw new Error(ex.fillInStackTrace());
        }
    }
}

