import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sqlite.Database;
import org.sqlite.Statement;
import org.sqlite.callback.ExecCallback;

public class WithoutJDBCExample {

    @org.junit.Test
    public void example() throws SQLException {
        // load JNI library
        System.loadLibrary("sqlite3jni");
        
        // change temp directory
        final Map<String, String> info = new HashMap<String, String>();
        info.put("TEMP_DIR", System.getProperty("user.home"));
        
        // open in-memory database
        final Database db = new Database(":memory:", info);
        try {
            // create table if not exists
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS sample("
                            + "  id INTEGER PRIMARY KEY"
                            + ", tVal TEXT"
                            + ", bVal BLOB"
                            + ", rVal REAL"
                        + ")";
            db.execute(sql);
            
            // begin transaction
            db.execute("BEGIN");

            // insert new record by using a named parameter
            sql = "INSERT INTO sample(tVal, bVal, rVal) "
                    + "VALUES(@text, @blob, @real)";
            final Statement stmt = db.prepare(sql);
            for (int i = 0; i < 5; ++i) {
                String text = Character.toString((char) ('1' + i));
                byte[] blob = ("Hello, SQLite3!" + text).getBytes();
                stmt.bindText(stmt.getParameterIndex("@text"), text);
                stmt.bindBytes(stmt.getParameterIndex("@blob"), blob);
                stmt.bindDouble(stmt.getParameterIndex("@real"), Math.sqrt(i));
                stmt.execute();
                stmt.reset();
            }
            stmt.close();
            
            // select all
            System.out.println("** select all records **");
            sql = "SELECT * FROM sample";
            final List<String[]> result = db.getTable(sql, null);
            for (final String[] values : result) {
                for (final String val : values) {
                    System.out.print(val + "|");
                }
                System.out.println();
            }
            System.out.println();
            
            // select all with callback function
            System.out.println("** select all records with callback function **");
            final ExecCallback callback
                    = new ExecCallback() {
                            @Override
                            protected int xCallback(String[] values, String[] columnNames) {
                                for (final String val : values) {
                                    System.out.print(val + "|");
                                }
                                System.out.println();
                                return 0;
                            }
                        };
            db.execute(sql, callback, null);
            
            // commit transaction
            db.execute("COMMIT");
            
        } finally {
            // close database
            db.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new WithoutJDBCExample().example();
    }
}
