/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.sqlite.Statement;
import org.sqlite.jdbc.JdbcDatabaseMetaData;
import org.sqlite.schema.ColumnMetaData;

public class JdbcResultSetMetaData
implements ResultSetMetaData {
    private final Statement stmt;

    public JdbcResultSetMetaData(Statement stmt) {
        this.stmt = stmt;
    }

    public int getColumnCount() throws SQLException {
        return this.stmt.getColumnCount();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        ColumnMetaData meta = this.getColumnMetaData(column);
        return meta.isAutoIncrement;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        ColumnMetaData meta = this.getColumnMetaData(column);
        return "NOCASE".equalsIgnoreCase(meta.collationSequenceName);
    }

    public boolean isSearchable(int column) throws SQLException {
        this.stmt.validateColumnIndexRange(column);
        return true;
    }

    public boolean isCurrency(int column) throws SQLException {
        this.stmt.validateColumnIndexRange(column);
        return false;
    }

    public int isNullable(int column) throws SQLException {
        ColumnMetaData meta = this.getColumnMetaData(column);
        return meta.isNotNull ? 0 : 1;
    }

    public boolean isSigned(int column) throws SQLException {
        return JdbcDatabaseMetaData.isSigned(this.getSQLiteColumnType(column));
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return JdbcDatabaseMetaData.getColumnDisplaySize(this.getSQLiteColumnType(column));
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.stmt.getColumnLabel(column);
    }

    public String getColumnName(int column) throws SQLException {
        return this.stmt.getColumnName(column);
    }

    public String getSchemaName(int column) throws SQLException {
        return this.getDatabaseName(column);
    }

    public int getPrecision(int column) throws SQLException {
        return JdbcDatabaseMetaData.getPrecision(this.getSQLiteColumnType(column));
    }

    public int getScale(int column) throws SQLException {
        return JdbcDatabaseMetaData.getScale(this.getSQLiteColumnType(column));
    }

    public String getTableName(int column) throws SQLException {
        return this.stmt.getColumnTableName(column);
    }

    public String getCatalogName(int column) throws SQLException {
        this.stmt.validateColumnIndexRange(column);
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        return JdbcDatabaseMetaData.getColumnType(this.getSQLiteColumnType(column));
    }

    public String getColumnTypeName(int column) throws SQLException {
        return this.stmt.getColumnTypeName(column);
    }

    public boolean isReadOnly(int column) throws SQLException {
        this.stmt.validateColumnIndexRange(column);
        return true;
    }

    public boolean isWritable(int column) throws SQLException {
        this.stmt.validateColumnIndexRange(column);
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        this.stmt.validateColumnIndexRange(column);
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        return JdbcDatabaseMetaData.getColumnClassName(this.getSQLiteColumnType(column));
    }

    public int getSQLiteColumnType(int column) throws SQLException {
        String name;
        int type = this.stmt.getColumnType(column);
        if (type != 3 && type != 4 && type != 2 && (name = this.stmt.getColumnTypeName(column)) != null) {
            type = "INTEGER".equals(name = name.toUpperCase()) || "INT".equals(name) ? 1 : ("TEXT".equals(name) || "VARCHAR".equals(name) || "CHAR".equals(name) || "CLOB".equals(name) ? 3 : ("BLOB".equals(name) ? 4 : ("REAL".equals(name) || "FLOA".equals(name) || "DOUB".equals(name) ? 2 : ("NULL".equals(name) ? 5 : 3))));
        }
        return type;
    }

    public String getDatabaseName(int column) throws SQLException {
        return this.stmt.getColumnDatabaseName(column);
    }

    public ColumnMetaData getColumnMetaData(int column) throws SQLException {
        String dbName = this.stmt.getColumnDatabaseName(column);
        String tableName = this.stmt.getColumnTableName(column);
        String columnName = this.stmt.getColumnName(column);
        return this.stmt.getDatabase().getColumnMetaData(dbName, tableName, columnName);
    }
}

