/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.sqlite.Statement;
import org.sqlite.auth.Authorizer;
import org.sqlite.event.BusyHandler;
import org.sqlite.event.CommitHook;
import org.sqlite.event.ProgressHandler;
import org.sqlite.event.RollbackHook;
import org.sqlite.event.UpdateHook;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.jdbc.TransactionType;
import org.sqlite.schema.ColumnMetaData;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_int;
import org.sqlite.swig.SWIGTYPE_p_p_char;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3_stmt;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.text.Collator;
import org.sqlite.types.SQLite3StmtPtrPtr;
import org.sqlite.udf.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    protected final Properties info;
    private final boolean isInMemory;
    private final SQLite3PtrPtr ppDb = new SQLite3PtrPtr();
    private Map<Long, Statement> statements;
    private Map<String, Function> functions;
    private Map<String, Collator> collators;
    private Authorizer authorizer;
    private BusyHandler busyHandler;
    private ProgressHandler progressHandler;
    private CommitHook commitHook;
    private RollbackHook rollbackHook;
    private UpdateHook updateHook;
    private int timeout;

    public Database(String filename, Properties info) throws SQLException {
        this.info = info;
        this.isInMemory = filename == null || SQLite3.getInMemoryFileName().equals(filename);
        this.open(filename);
    }

    public String getProductName() {
        return "SQLite";
    }

    public boolean isInMemoryMode() {
        return this.isInMemory;
    }

    private SWIGTYPE_p_sqlite3 getInstance() {
        return this.ppDb.getSQLite3Ptr();
    }

    private void open(String filename) throws SQLException {
        int ret = SQLite3.sqlite3_open(filename, this.ppDb);
        if (ret != 0) {
            SWIGTYPE_p_sqlite3 db = this.getInstance();
            JdbcSQLException ex = new JdbcSQLException(db);
            this.ppDb.delete();
            throw ex;
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isClosed() {
        return this.ppDb.isDeleted();
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.closeStatements();
            this.dropFunctions();
            this.dropCollators();
            this.internalClearAuthorizer();
            this.internalClearBusyHandler();
            this.clearProgressHandler();
            this.clearCommitHook();
            this.clearRollbackHook();
            this.clearUpdateHook();
            SWIGTYPE_p_sqlite3 db = this.getInstance();
            int ret = SQLite3.sqlite3_close(db);
            if (ret != 0) {
                throw new JdbcSQLException(db);
            }
            this.ppDb.delete();
        }
    }

    public boolean getAutoCommit() {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        return SQLite3.sqlite3_get_autocommit(db) != 0;
    }

    public void setBusyTimeout(int ms) throws SQLException {
        this.clearBusyHandler();
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.sqlite3_busy_timeout(db, ms);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        this.timeout = ms < 1 ? 0 : ms;
    }

    public int getBusyTimeout() {
        return this.timeout;
    }

    public int execute(String sql) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = 0;
        if (this.timeout == 0) {
            while ((ret = SQLite3.sqlite3_exec(db, sql)) == 5) {
            }
        } else {
            ret = SQLite3.sqlite3_exec(db, sql);
            if (ret == 5) {
                throw new JdbcSQLException("Timeout expired.", 5);
            }
        }
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        return ret;
    }

    public void pragma(String[] commands) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        for (String cmd : commands) {
            int ret = SQLite3.sqlite3_exec(db, "PRAGMA " + cmd);
            if (ret == 0) continue;
            throw new JdbcSQLException(db);
        }
    }

    public void beginTransaction(TransactionType type) throws SQLException {
        this.closeStatements();
        if (type == null) {
            this.execute("BEGIN");
        } else {
            this.execute("BEGIN " + (Object)((Object)type));
        }
    }

    public void commitTransaction() throws SQLException {
        this.closeStatements();
        this.execute("COMMIT");
    }

    public void rollbackTransaction() throws SQLException {
        this.closeStatements();
        this.execute("ROLLBACK");
    }

    public Statement prepare(String sql, SQLite3StmtPtrPtr ppStmt) throws SQLException {
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        if (ppStmt == null) {
            throw new NullPointerException("ppStmt is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        return new Statement(this, ppStmt.getSQLite3StmtPtr());
    }

    public Statement prepare(String sql) throws SQLException {
        SQLite3StmtPtrPtr ppStmt;
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt = new SQLite3StmtPtrPtr());
        if (ret != 0) {
            ppStmt.delete();
            throw new JdbcSQLException(db);
        }
        return new Statement(this, ppStmt);
    }

    public List<Statement> prepareMultiple(String sql) throws SQLException {
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        ArrayList<SQLite3StmtPtrPtr> stmts = new ArrayList<SQLite3StmtPtrPtr>();
        String[] tail = new String[1];
        do {
            SQLite3StmtPtrPtr ppStmt = new SQLite3StmtPtrPtr();
            stmts.add(ppStmt);
            int ret = SQLite3.sqlite3_prepare(db, sql, -1, (SWIGTYPE_p_p_sqlite3_stmt)ppStmt, tail);
            if (ret == 0) continue;
            for (SQLite3StmtPtrPtr stmt : stmts) {
                stmt.delete();
            }
            throw new JdbcSQLException(db);
        } while ((sql = tail[0].trim()).length() > 0);
        ArrayList<Statement> ret = new ArrayList<Statement>(stmts.size());
        for (SQLite3StmtPtrPtr stmt : stmts) {
            ret.add(new Statement(this, stmt));
        }
        return ret;
    }

    public void interrupt() throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SQLite3.sqlite3_interrupt(db);
        this.closeStatements();
    }

    public int changes() {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        return SQLite3.sqlite3_changes(db);
    }

    public int totalChanges() {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        return SQLite3.sqlite3_total_changes(db);
    }

    public long lastInsertRowId() {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        return SQLite3.sqlite3_last_insert_rowid(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnMetaData getColumnMetaData(String dbName, String tableName, String columnName) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SWIGTYPE_p_p_char dataType = null;
        SWIGTYPE_p_p_char collSeq = null;
        SWIGTYPE_p_int notNull = null;
        SWIGTYPE_p_int primaryKey = null;
        SWIGTYPE_p_int autoInc = null;
        try {
            dataType = SQLite3.new_p_p_char();
            collSeq = SQLite3.new_p_p_char();
            notNull = SQLite3.new_p_int();
            primaryKey = SQLite3.new_p_int();
            autoInc = SQLite3.new_p_int();
            int ret = SQLite3.sqlite3_table_column_metadata(db, dbName, tableName, columnName, dataType, collSeq, notNull, primaryKey, autoInc);
            if (ret != 0) {
                throw new JdbcSQLException(db);
            }
            ColumnMetaData columnMetaData = new ColumnMetaData(SQLite3.p_p_char_value(dataType), SQLite3.p_p_char_value(collSeq), SQLite3.p_int_value(notNull), SQLite3.p_int_value(primaryKey), SQLite3.p_int_value(autoInc));
            return columnMetaData;
        }
        finally {
            if (dataType != null) {
                SQLite3.delete_p_p_char(dataType);
            }
            if (collSeq != null) {
                SQLite3.delete_p_p_char(collSeq);
            }
            if (notNull != null) {
                SQLite3.delete_p_int(notNull);
            }
            if (primaryKey != null) {
                SQLite3.delete_p_int(primaryKey);
            }
            if (autoInc != null) {
                SQLite3.delete_p_int(autoInc);
            }
        }
    }

    void addStatement(Statement stmt) throws SQLException {
        long key;
        if (this.statements == null) {
            this.statements = new HashMap<Long, Statement>();
        }
        if (this.statements.containsKey(key = stmt.getHandle())) {
            throw new SQLException("Duplicate sqlite3_stmt handle error.", "90J31");
        }
        this.statements.put(key, stmt);
    }

    void removeStatement(Statement stmt) throws SQLException {
        long key;
        if (this.statements != null && this.statements.remove(key = stmt.getHandle()) == null) {
            throw new SQLException("Unmanaged sqlite3_stmt handle error.", "90J32");
        }
    }

    private void closeStatements() {
        if (this.statements != null) {
            Collection<Statement> list = this.statements.values();
            this.statements = null;
            for (Statement stmt : list) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(Database.class.getName()).info(ex.toString());
                }
            }
        }
    }

    private void addFunction(Function func) {
        if (this.functions == null) {
            this.functions = new HashMap<String, Function>();
        }
        this.functions.put(func.getName().toUpperCase(), func);
    }

    private void removeFunction(Function func) {
        if (this.functions != null) {
            this.functions.remove(func.getName().toUpperCase());
        }
    }

    private void dropFunctions() {
        if (this.functions != null) {
            Collection<Function> list = this.functions.values();
            this.functions = null;
            for (Function func : list) {
                if (!func.isRegistered()) continue;
                try {
                    this.dropFunction(func);
                }
                catch (SQLException ex) {
                    Logger.getLogger(Database.class.getName()).info(ex.toString());
                }
            }
        }
    }

    public void createFunction(Function func) throws SQLException {
        SWIGTYPE_p_sqlite3 db;
        int ret;
        Function old;
        if (this.functions != null && (old = this.functions.get(func.getName().toUpperCase())) != null) {
            this.dropFunction(old);
        }
        if ((ret = SQLite3.create_function(db = this.getInstance(), func)) != 0) {
            throw new JdbcSQLException(db);
        }
        this.addFunction(func);
    }

    public void dropFunction(Function func) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.drop_function(db, func);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        this.removeFunction(func);
    }

    private void addCollator(Collator col) {
        if (this.collators == null) {
            this.collators = new HashMap<String, Collator>();
        }
        this.collators.put(col.getName().toUpperCase(), col);
    }

    private void removeCollator(Collator col) {
        if (this.collators != null) {
            this.collators.remove(col.getName().toUpperCase());
        }
    }

    private void dropCollators() {
        if (this.collators != null) {
            Collection<Collator> list = this.collators.values();
            this.collators = null;
            for (Collator col : list) {
                if (!col.isRegistered()) continue;
                try {
                    this.dropCollation(col);
                }
                catch (SQLException ex) {
                    Logger.getLogger(Database.class.getName()).info(ex.toString());
                }
            }
        }
    }

    public void createCollation(Collator col) throws SQLException {
        SWIGTYPE_p_sqlite3 db;
        int ret;
        Collator old;
        if (this.collators != null && (old = this.collators.get(col.getName().toUpperCase())) != null) {
            this.dropCollation(old);
        }
        if ((ret = SQLite3.create_collation(db = this.getInstance(), col)) != 0) {
            throw new JdbcSQLException(db);
        }
        this.addCollator(col);
    }

    public void dropCollation(Collator col) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.drop_collation(db, col);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        this.removeCollator(col);
    }

    public void setAuthorizer(Authorizer auth) throws SQLException {
        this.clearAuthorizer();
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.set_authorizer(db, auth);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        this.authorizer = auth;
    }

    public void clearAuthorizer(Authorizer auth) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.clear_authorizer(db, auth);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
    }

    public void clearAuthorizer() throws SQLException {
        if (this.authorizer != null) {
            this.clearAuthorizer(this.authorizer);
            this.authorizer = null;
        }
    }

    private void internalClearAuthorizer() {
        try {
            this.clearAuthorizer();
        }
        catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).info(ex.toString());
        }
    }

    public void setBusyHandler(BusyHandler busy) throws SQLException {
        this.clearBusyHandler();
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.set_busy_handler(db, busy);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        this.busyHandler = busy;
        this.timeout = -1;
    }

    public void clearBusyHandler(BusyHandler busy) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.clear_busy_handler(db, busy);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
    }

    public void clearBusyHandler() throws SQLException {
        if (this.busyHandler != null) {
            this.clearBusyHandler(this.busyHandler);
            this.busyHandler = null;
        }
    }

    private void internalClearBusyHandler() {
        try {
            this.clearBusyHandler();
        }
        catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).info(ex.toString());
        }
    }

    public void setProgressHandler(ProgressHandler prog) {
        this.clearProgressHandler();
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SQLite3.set_progress_handler(db, prog);
        this.progressHandler = prog;
    }

    public void clearProgressHandler(ProgressHandler prog) {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SQLite3.clear_progress_handler(db, prog);
    }

    public void clearProgressHandler() {
        if (this.progressHandler != null) {
            this.clearProgressHandler(this.progressHandler);
            this.progressHandler = null;
        }
    }

    public void setCommitHook(CommitHook hook) {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SQLite3.set_commit_hook(db, hook);
        this.commitHook = hook;
    }

    public void clearCommitHook(CommitHook hook) {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SQLite3.clear_commit_hook(db, hook);
    }

    public void clearCommitHook() {
        if (this.commitHook != null) {
            if (this.commitHook.isRegistered()) {
                this.clearCommitHook(this.commitHook);
            }
            this.commitHook = null;
        }
    }

    public void setRollbackHook(RollbackHook hook) {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SQLite3.set_rollback_hook(db, hook);
        this.rollbackHook = hook;
    }

    public void clearRollbackHook(RollbackHook hook) {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SQLite3.clear_rollback_hook(db, hook);
    }

    public void clearRollbackHook() {
        if (this.rollbackHook != null) {
            if (this.rollbackHook.isRegistered()) {
                this.clearRollbackHook(this.rollbackHook);
            }
            this.rollbackHook = null;
        }
    }

    public void setUpdateHook(UpdateHook hook) {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SQLite3.set_update_hook(db, hook);
        this.updateHook = hook;
    }

    public void clearUpdateHook(UpdateHook hook) {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SQLite3.clear_update_hook(db, hook);
    }

    public void clearUpdateHook() {
        if (this.updateHook != null) {
            if (this.updateHook.isRegistered()) {
                this.clearUpdateHook(this.updateHook);
            }
            this.updateHook = null;
        }
    }

    public void enableSharedCache() throws SQLException {
        int ret = SQLite3.sqlite3_enable_shared_cache(1);
        if (ret != 0) {
            SWIGTYPE_p_sqlite3 db = this.getInstance();
            throw new JdbcSQLException(db);
        }
    }

    public void disableSharedCache() throws SQLException {
        int ret = SQLite3.sqlite3_enable_shared_cache(0);
        if (ret != 0) {
            SWIGTYPE_p_sqlite3 db = this.getInstance();
            throw new JdbcSQLException(db);
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            Logger.getLogger("global").severe("Database connection has leaked!");
        }
        super.finalize();
    }

    private static class SQLite3PtrPtr
    extends SWIGTYPE_p_p_sqlite3 {
        private boolean isDeleted = false;

        public SQLite3PtrPtr() {
            super(SQLite3PtrPtr.getCPtr(SQLite3.new_p_p_sqlite3()), false);
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public synchronized void delete() {
            if (!this.isDeleted) {
                SQLite3.delete_p_p_sqlite3(this);
                this.isDeleted = true;
            }
        }

        public SWIGTYPE_p_sqlite3 getSQLite3Ptr() {
            if (this.isDeleted) {
                throw new IllegalStateException("SQLite3PtrPtr is already deleted.");
            }
            return SQLite3.p_p_sqlite3_value(this);
        }

        protected void finalize() throws Throwable {
            this.delete();
            super.finalize();
        }
    }
}

