/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class DriverTest {

    public DriverTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    // The methods must be annotated with annotation @Test. For example:
    //
    // @Test
    // public void hello() {}

//    private static final String JAVA_LIBRARY_PATH
//            = System.getProperty("java.library.path");
    
    private static final String JNI_PATH
            = "C:\\Java\\sqlite3jni\\sqlite3.3.5\\win32";
    
    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    
//    @Test(expected=java.lang.UnsatisfiedLinkError.class)
//    public void loadFailed() throws Exception {
//        String libPath = System.getProperty("java.library.path");
//        if (libPath != null) {
//            // remove JNI_PATH
//            StringBuilder newPath = new StringBuilder();
//            for (String path : libPath.split(File.pathSeparator)) {
//                if (!path.equalsIgnoreCase(JNI_PATH)) {
//                    newPath.append(path).append(File.pathSeparator);
//                }
//            }
//            if (newPath.toString().endsWith(File.pathSeparator)) {
//                newPath.delete(newPath.length() - 1, newPath.length());
//            }
//            libPath = newPath.toString();
//            System.setProperty("java.library.path", libPath);
//        }
//        Class.forName(DRIVER_CLASS);
//    }
    
    @Test
    public void loadSuccessful() throws Exception {
//        System.setProperty("java.library.path", JNI_PATH);
        Class.forName(DRIVER_CLASS);
    }
    
//    @Test
//    public void getConnectionFailed() throws Exception {
//        System.setProperty("java.library.path", JNI_PATH);
//        Class.forName(DRIVER_CLASS);
//        Connection conn = null;
//        try {
//            conn = DriverManager.getConnection("jdbc:sqlite3:C:\\tmp\\sample.db");
//            assertNull(conn);
//        } finally {
//            if (conn != null) {
//                conn.close();
//            }
//        }
//    }

    @Test
    public void getConnectionSuccessful() throws Exception {
//        System.setProperty("java.library.path", JNI_PATH);
        Class.forName(DRIVER_CLASS);
        Connection conn = null;
        try {
            conn = DriverManager.getConnection("jdbc:sqlite:test/unittest.db");
            assertNotNull(conn);
        } finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @Test
    public void createStatement() throws Exception {
//        System.setProperty("java.library.path", JNI_PATH);
        Class.forName(DRIVER_CLASS);
        Connection conn = null;
        try {
            conn = DriverManager.getConnection("jdbc:sqlite:test/unittest.db");
            assertNotNull(conn);
            Statement stmt = conn.createStatement();
            assertNotNull(stmt);
            int nextId = 0;
            for (ResultSet rs = stmt.executeQuery("SELECT MAX(id) FROM sample;"); rs.next(); ) {
                nextId = rs.getInt(1) + 1;
                rs.close();
                break;
            }

            for (int i = 0; i < 100; ++i) {
                conn.createStatement();
            }
            System.gc();
            
            int ret = 0;
            
            if (nextId > 1) {
                PreparedStatement pstmt = conn.prepareStatement("UPDATE sample SET value = ? WHERE id = ?");
                pstmt.setString(1, "MAX(ID)の値を持つレコードです①");
                pstmt.setInt(2, nextId - 1);
                ret = pstmt.executeUpdate();
                assertEquals(ret, 1);

                pstmt.setString(1, "have MAX(ID) - 2 record.");
                pstmt.setInt(2, nextId - 2);
                ret = pstmt.executeUpdate();
                assertEquals(ret, 1);
                pstmt.close();
            }
            
            conn.setAutoCommit(false);
            ResultSet rsTmp = stmt.executeQuery("SELECT id, value FROM sample ORDER BY id DESC;");
            rsTmp.next();
            int id = rsTmp.getInt(1);
            rsTmp.close();
            
            for (int i = nextId; i < (nextId + 3); ++i) {
                ret = stmt.executeUpdate("INSERT INTO sample(id, value) VALUES(" + i + ", 'てすと:" + i + "')");
                assertEquals(ret, 1);
            }
            
//            rsTmp.next();
//            id = rsTmp.getInt(1);
//            
//            rsTmp.close();
            
            conn.commit();
//            conn.rollback();
            
            for (ResultSet rs = stmt.executeQuery("SELECT id, value as val FROM sample;"); rs.next(); ) {
                System.out.println(rs.getInt("ID") + " | " + rs.getString("VAL"));
            }
            stmt.close();
        } catch (SQLException ex) {
            ex.printStackTrace();
            throw ex;
        
        } finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
    
    @Test
    public void finalizeTest() throws Throwable {
        String filename = "test/unittest.db";
        System.out.println("database file is '" + filename + "'");
        System.out.flush();

        try {
            Class.forName("org.sqlite.Driver");
            filename = "file:" + filename;
            System.out.println("org.sqlite.Driver loaded");
        } catch (Exception e) {
            Class.forName("SQLite.JDBCDriver");
            filename = "/" + filename;
            System.out.println("SQLite.JDBCDriver loaded");
        }
        System.out.flush();

        Connection conn
            = DriverManager.getConnection("jdbc:sqlite:" + filename);
//        System.out.println("conn is " + conn);
//        System.out.flush();
        try {
            Statement stmt = conn.createStatement();
//            System.out.println("stmt is " + stmt);
//            System.out.flush();
            int ret = 0;

            int nextId = 1;
//            try {
//                ret = stmt.executeUpdate("DELETE FROM sample");
                ret = stmt.executeUpdate("DROP TABLE sample");
//            } catch (SQLException ex) {
//                System.out.println(ex.getMessage() + "(" + ex.getErrorCode() + ")");
//                if (ex.getErrorCode() == 1) {
//                    // table not found
//                    stmt.executeUpdate("CREATE TABLE sample(id integer primary key, value text)");
//                }
//            }
//            ret = stmt.executeUpdate("CREATE TABLE IF NOT EXISTS sample(id integer PRIMARY KEY AUTOINCREMENT, value text NOT NULL DEFAULT '_blank')");
            ret = stmt.executeUpdate(
                        "CREATE TABLE IF NOT EXISTS sample("
                            + "  ROWID integer PRIMARY KEY AUTOINCREMENT"
                            + ", id integer NOT NULL DEFAULT 0 COLLATE BINARY"
                            + ", value text NOT NULL COLLATE NOCASE"
                        + ")"
                    );

            for (ResultSet rs = stmt.executeQuery("PRAGMA table_info(sample)"); rs.next(); ) {
                final ResultSetMetaData rsMeta = rs.getMetaData();
                for (int i = 0; i < rsMeta.getColumnCount(); ++i) {
                    int type = rsMeta.getColumnType(i + 1);
                    System.out.print(rsMeta.getColumnLabel(i + 1) + " | ");
                }
                System.out.println();

                for (int i = 0; i < rsMeta.getColumnCount(); ++i) {
                    System.out.print(rs.getString(i + 1) + " | ");
                }
                System.out.println();
            }
            
            ResultSet rsId = stmt.executeQuery("SELECT MAX(id) FROM sample");
            if (rsId.next()) {
                ResultSetMetaData rsMeta = rsId.getMetaData();
                int precision = rsMeta.getPrecision(1);
                nextId = rsId.getInt(1) + 1;
            }
            rsId.close();
            
            PreparedStatement pstmt2 = conn.prepareStatement("SELECT * FROM sqlite_master WHERE (?1 IS NULL OR name LIKE ?1) AND type = ?2");
            pstmt2.setString(1, "%");
            pstmt2.setString(2, "table");
            for (ResultSet rs = pstmt2.executeQuery(); rs.next(); ) {
                int cntColumns = rs.getMetaData().getColumnCount();
                for (int i = 1; i <= cntColumns; ++i) {
                    System.out.print(rs.getString(i) + " | ");            
                }
                System.out.println();                  
            }
            pstmt2.close();
            
            DatabaseMetaData dbMeta = conn.getMetaData();
//            ResultSet rsTbl = dbMeta.getTables(null, null, "%sample%", null);
            ResultSet rsTbl = dbMeta.getTables(null, null, "%", null);
            while (rsTbl.next()) {
                System.out.println(rsTbl.getString("TABLE_TYPE") + " | " + rsTbl.getString("TABLE_NAME"));
            }
            
            ResultSet rsTypeInfo = dbMeta.getTypeInfo();
            int cntColumns = rsTypeInfo.getMetaData().getColumnCount();
            while (rsTypeInfo.next()) {
                for (int i = 1; i <= cntColumns; ++i) {
                    System.out.print(rsTypeInfo.getString(i) + " | ");                  
                }
                System.out.println();                  
            }
            rsTypeInfo.close();
            
//            ResultSet rsCol = dbMeta.getColumns(null, null, "sample", null);
//            rsCol.close();
            
            
            conn.setAutoCommit(false);
            final int max = nextId + 10;
            for (; nextId < max; ++nextId) {
                ret = stmt.executeUpdate("INSERT INTO sample(id, value) VALUES(" + nextId + ", 'てすと:" + nextId + "')");
                assertEquals(ret, 1);
            }
//            rsTbl.next();
            
            conn.commit();
//            conn.rollback();
            
            PreparedStatement pstmt = conn.prepareStatement("UPDATE sample SET value = ? WHERE id = ?");
            pstmt.setString(1, "MAX(ID)の値を持つレコードです①");
            pstmt.setInt(2, nextId - 1);
            ret = pstmt.executeUpdate();
            assertEquals(ret, 1);

            pstmt.setString(1, "have MAX(ID) - 2 record.");
            pstmt.setInt(2, nextId - 2);
            ret = pstmt.executeUpdate();
            pstmt.close();
            assertEquals(ret, 1);
            
            for (ResultSet rs = stmt.executeQuery("SELECT ROWID, id AS PK, value AS VAL FROM sample;"); rs.next(); ) {
                ResultSetMetaData rsMeta = rs.getMetaData();
                boolean isAutoInc = rsMeta.isAutoIncrement(1);
                boolean isCase = rsMeta.isCaseSensitive(1);
                int isNull = rsMeta.isNullable(1);
                isAutoInc = rsMeta.isAutoIncrement(2);
                isCase = rsMeta.isCaseSensitive(2);
                isNull = rsMeta.isNullable(2);
                isAutoInc = rsMeta.isAutoIncrement(3);
                isCase = rsMeta.isCaseSensitive(3);
                isNull = rsMeta.isNullable(3);
                
                String label = rsMeta.getColumnLabel(1);
                String name = rsMeta.getColumnName(1);
                label = rsMeta.getColumnLabel(2);
                name = rsMeta.getColumnName(2);
                String cname = rsMeta.getColumnClassName(1);
                cname = rsMeta.getColumnClassName(2);
                
                System.out.println(rs.getString(1) + " | " + rs.getString(2));
            }
            stmt.close();
            
//            pstmt = conn.prepareStatement("SELECT * FROM sample");
//            for (ResultSet rs = pstmt.executeQuery(); rs.next(); ) {
//                System.out.println(rs.getString(1) + " | " + rs.getString(2));
//            }
//            pstmt.close();
            
            stmt = conn.createStatement();
            ret = stmt.executeUpdate("CREATE TABLE IF NOT EXISTS blob_sample(id integer primary key, value blob)");
            pstmt = conn.prepareStatement("INSERT INTO blob_sample(value) VALUES(?)");
            byte[] bytes = new byte[20];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte) ('A' + i);
            }
            pstmt.setBytes(1, bytes);
            ret = pstmt.executeUpdate();
            assertEquals(ret, 1);
            pstmt.close();
            
            for (ResultSet rs = stmt.executeQuery("SELECT * FROM blob_sample;"); rs.next(); ) {
                byte[] value = rs.getBytes(2);
                Blob blob = rs.getBlob(2);
                byte[] value2 = blob.getBytes(5, 20);
                String v2 = new String(value2);
                long skiped = blob.getBinaryStream().skip(19);
                
                byte[] buff = new byte[32];
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                for (final InputStream in = blob.getBinaryStream(); in.read(buff) != -1; ) {
                    bout.write(buff);
                }
                bout.toString();
                
                System.out.println(rs.getString(1) + " | " + rs.getString(2) + " | " + new String(value));
            }
            stmt.close();
            
        } catch (SQLException ex) {
            System.out.println(ex.getMessage() + "(" + ex.getErrorCode() + ")");
            ex.printStackTrace();
            throw ex.fillInStackTrace();
            
        } catch (Exception ex) {
            ex.printStackTrace();
            throw ex.fillInStackTrace();
            
        } finally {
            conn.close();
        }
    }
    
    public static void main(String[] args) throws Throwable {
        new DriverTest().finalizeTest();
    }
}