/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.udf;

import java.sql.SQLException;
import java.util.logging.Logger;
import org.sqlite.udf.Context;
import org.sqlite.udf.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregateFunction<T>
extends Function {
    protected final ThreadLocal<T> tls = new ThreadLocal<T>(){

        @Override
        protected T initialValue() {
            return AggregateFunction.this.internalInitialValue();
        }
    };

    public AggregateFunction(String name, int argc) {
        super(name, argc);
    }

    public AggregateFunction(String name) {
        super(name);
    }

    @Override
    protected final void xFunc(Context ctx) throws SQLException {
        this.xStep(ctx);
    }

    protected final void xFinal(long context) {
        Context ctx = null;
        try {
            ctx = new Context(context);
            this.xFinal(ctx);
        }
        catch (Throwable th) {
            if (ctx != null) {
                String msg = th.toString();
                ctx.resultError(msg != null ? msg : "Unknown error.");
            }
            Logger.getLogger(AggregateFunction.class.getName()).fine("Exception occurred: " + th.toString());
        }
    }

    private T internalInitialValue() {
        return this.initialValue();
    }

    protected abstract T initialValue();

    protected T get() {
        return this.tls.get();
    }

    protected void remove() {
        this.tls.remove();
    }

    protected void set(T value) {
        this.tls.set(value);
    }

    protected abstract void xStep(Context var1) throws SQLException;

    protected abstract void xFinal(Context var1) throws SQLException;
}

