/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.SQLException;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3_stmt;

public class JdbcSQLException
extends SQLException {
    public JdbcSQLException(SWIGTYPE_p_sqlite3 db) {
        this(SQLite3.sqlite3_errmsg(db), SQLite3.sqlite3_errcode(db));
    }

    public JdbcSQLException(SWIGTYPE_p_sqlite3_stmt stmt) {
        this(SQLite3.sqlite3_db_handle(stmt));
    }

    public JdbcSQLException(String reason, int vendorCode) {
        super(reason, JdbcSQLException.getSQLState(vendorCode), vendorCode);
    }

    public static String getSQLState(int errcode) {
        String subclass = ("000" + errcode).substring(0, 3);
        switch (errcode) {
            case 0: 
            case 100: 
            case 101: {
                return "00" + subclass;
            }
            case 4: 
            case 9: {
                return "02" + subclass;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return "HY" + subclass;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return "90" + subclass;
            }
            case 19: {
                return "23" + subclass;
            }
            case 14: {
                return "08" + subclass;
            }
            case 21: {
                return "42" + subclass;
            }
        }
        return null;
    }
}

