/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.sqlite.Statement;
import org.sqlite.TransactionType;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.schema.ColumnMetaData;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SWIGTYPE_p_int;
import org.sqlite.swig.SWIGTYPE_p_p_char;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.types.SQLite3StmtPtrPtr;
import org.sqlite.udf.Function;

public class Database {
    private final SQLite3PtrPtr ppDb = new SQLite3PtrPtr();
    private Map<Long, Statement> statements;
    private List<Function> functions;
    protected final Properties info;
    private final boolean isInMemory;
    private int timeout;

    public Database(String filename, Properties info) throws SQLException {
        this.info = info;
        this.isInMemory = filename == null || SQLite3.getInMemoryFileName().equals(filename);
        this.open(filename);
    }

    public String getProductName() {
        return "SQLite";
    }

    public boolean isInMemoryMode() {
        return this.isInMemory;
    }

    private SWIGTYPE_p_sqlite3 getInstance() {
        return this.ppDb.getSQLite3Ptr();
    }

    private void open(String filename) throws SQLException {
        int ret = SQLite3.sqlite3_open(filename, this.ppDb);
        if (ret != 0) {
            SWIGTYPE_p_sqlite3 db = this.getInstance();
            JdbcSQLException ex = new JdbcSQLException(db);
            this.ppDb.delete();
            throw ex;
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isClosed() {
        return this.ppDb.isDeleted();
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.closeStatements();
            this.unregisterFunctions();
            SWIGTYPE_p_sqlite3 db = this.getInstance();
            int ret = SQLite3.sqlite3_close(db);
            if (ret != 0) {
                throw new JdbcSQLException(db);
            }
            this.ppDb.delete();
        }
    }

    public boolean getAutoCommit() {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        return SQLite3.sqlite3_get_autocommit(db) != 0;
    }

    public int setBusyTimeout(int ms) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.sqlite3_busy_timeout(db, ms);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        this.timeout = ms < 1 ? 0 : ms;
        return ret;
    }

    public int getBusyTimeout() {
        return this.timeout;
    }

    public int execute(String sql) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = 0;
        if (this.timeout == 0) {
            while ((ret = SQLite3.sqlite3_exec(db, sql)) == 5) {
            }
        } else {
            ret = SQLite3.sqlite3_exec(db, sql);
            if (ret == 5) {
                throw new JdbcSQLException("Timeout expired.", 5);
            }
        }
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        return ret;
    }

    public void pragma(String[] commands) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        for (String cmd : commands) {
            int ret = SQLite3.sqlite3_exec(db, "PRAGMA " + cmd);
            if (ret == 0) continue;
            throw new JdbcSQLException(db);
        }
    }

    public void beginTransaction(TransactionType type) throws SQLException {
        this.closeStatements();
        if (type == null) {
            this.execute("BEGIN");
        } else {
            this.execute("BEGIN " + (Object)((Object)type));
        }
    }

    public void commitTransaction() throws SQLException {
        this.closeStatements();
        this.execute("COMMIT");
    }

    public void rollbackTransaction() throws SQLException {
        this.closeStatements();
        this.execute("ROLLBACK");
    }

    public Statement prepare(String sql, SQLite3StmtPtrPtr ppStmt) throws SQLException {
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        if (ppStmt == null) {
            throw new NullPointerException("ppStmt is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt, null);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        return new Statement(this, ppStmt.getSQLite3StmtPtr());
    }

    public Statement prepare(String sql) throws SQLException {
        SQLite3StmtPtrPtr ppStmt;
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt = new SQLite3StmtPtrPtr(), null);
        if (ret != 0) {
            ppStmt.delete();
            throw new JdbcSQLException(db);
        }
        return new Statement(this, ppStmt);
    }

    public void interrupt() throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SQLite3.sqlite3_interrupt(db);
        this.closeStatements();
    }

    public int changes() {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        return SQLite3.sqlite3_changes(db);
    }

    public int totalChanges() {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        return SQLite3.sqlite3_total_changes(db);
    }

    public long lastInsertRowId() {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        return SQLite3.sqlite3_last_insert_rowid(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnMetaData getColumnMetaData(String dbName, String tableName, String columnName) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        SWIGTYPE_p_p_char dataType = null;
        SWIGTYPE_p_p_char collSeq = null;
        SWIGTYPE_p_int notNull = null;
        SWIGTYPE_p_int primaryKey = null;
        SWIGTYPE_p_int autoInc = null;
        try {
            dataType = SQLite3.new_p_p_char();
            collSeq = SQLite3.new_p_p_char();
            notNull = SQLite3.new_p_int();
            primaryKey = SQLite3.new_p_int();
            autoInc = SQLite3.new_p_int();
            int ret = SQLite3.sqlite3_table_column_metadata(db, dbName, tableName, columnName, dataType, collSeq, notNull, primaryKey, autoInc);
            if (ret != 0) {
                throw new JdbcSQLException(db);
            }
            ColumnMetaData columnMetaData = new ColumnMetaData(SQLite3.p_p_char_value(dataType), SQLite3.p_p_char_value(collSeq), SQLite3.p_int_value(notNull), SQLite3.p_int_value(primaryKey), SQLite3.p_int_value(autoInc));
            return columnMetaData;
        }
        finally {
            if (dataType != null) {
                SQLite3.delete_p_p_char(dataType);
            }
            if (collSeq != null) {
                SQLite3.delete_p_p_char(collSeq);
            }
            if (notNull != null) {
                SQLite3.delete_p_int(notNull);
            }
            if (primaryKey != null) {
                SQLite3.delete_p_int(primaryKey);
            }
            if (autoInc != null) {
                SQLite3.delete_p_int(autoInc);
            }
        }
    }

    void addStatement(Statement stmt) throws SQLException {
        long key;
        if (this.statements == null) {
            this.statements = new HashMap<Long, Statement>();
        }
        if (this.statements.containsKey(key = stmt.getHandle())) {
            throw new SQLException("Duplicate sqlite3_stmt handle error.", "90J31");
        }
        this.statements.put(key, stmt);
    }

    void removeStatement(Statement stmt) throws SQLException {
        long key;
        if (this.statements != null && this.statements.remove(key = stmt.getHandle()) == null) {
            throw new SQLException("Unmanaged sqlite3_stmt handle error.", "90J32");
        }
    }

    private void closeStatements() {
        if (this.statements != null) {
            Collection<Statement> list = this.statements.values();
            this.statements = null;
            for (Statement stmt : list) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(Database.class.getName()).info(ex.toString());
                }
            }
        }
    }

    private void addFunction(Function func) {
        if (this.functions == null) {
            this.functions = new ArrayList<Function>();
        }
        if (!this.functions.contains(func)) {
            this.functions.add(func);
        }
    }

    private void removeFunction(Function func) {
        if (this.functions != null) {
            this.functions.remove(func);
        }
    }

    private void unregisterFunctions() {
        if (this.functions != null) {
            List<Function> list = this.functions;
            this.functions = null;
            for (Function func : list) {
                try {
                    this.unregisterFunction(func);
                }
                catch (SQLException ex) {
                    Logger.getLogger(Database.class.getName()).info(ex.toString());
                }
            }
        }
    }

    public void registerFunction(Function func) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.register_function(db, func);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        this.addFunction(func);
    }

    public void unregisterFunction(Function func) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.getInstance();
        int ret = SQLite3.unregister_function(db, func);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        this.removeFunction(func);
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            Logger.getLogger("global").severe("Database connection has leaked!");
        }
        super.finalize();
    }

    private static class SQLite3PtrPtr
    extends SWIGTYPE_p_p_sqlite3 {
        private boolean isDeleted = false;

        public SQLite3PtrPtr() {
            super(SQLite3PtrPtr.getCPtr(SQLite3.new_p_p_sqlite3()), false);
        }

        public boolean isDeleted() {
            return this.isDeleted;
        }

        public synchronized void delete() {
            if (!this.isDeleted) {
                SQLite3.delete_p_p_sqlite3(this);
                this.isDeleted = true;
            }
        }

        public SWIGTYPE_p_sqlite3 getSQLite3Ptr() {
            if (this.isDeleted) {
                throw new IllegalStateException("SQLite3PtrPtr is already deleted.");
            }
            return SQLite3.p_p_sqlite3_value(this);
        }

        protected void finalize() throws Throwable {
            this.delete();
            super.finalize();
        }
    }
}

