/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;
import org.sqlite.Statement;
import org.sqlite.jdbc.JdbcBlob;
import org.sqlite.jdbc.JdbcPreparedStatement;
import org.sqlite.jdbc.JdbcResultSetMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcResultSet
implements ResultSet {
    private final java.sql.Statement owner;
    private final Statement stmt;
    private boolean isClosed = false;
    private boolean isBeforeFirst = true;
    private boolean isFirst = false;
    private boolean isAfterLast = false;
    private int currentRow = 0;
    private int lastRow = -1;
    private String[] columnLabels;
    private int[] columnTypes;
    private int lastColumnReadIndex;
    private JdbcBlob blob;

    public JdbcResultSet(java.sql.Statement owner, Statement stmt) throws SQLException {
        this.owner = owner;
        this.stmt = stmt;
        stmt.reset();
    }

    @Override
    public boolean next() throws SQLException {
        this.validateResultSetOpen();
        if (this.blob != null) {
            this.blob.close();
            this.blob = null;
        }
        if (this.isAfterLast) {
            return false;
        }
        int ret = this.stmt.step();
        if (ret == 100) {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
                this.isFirst = true;
                if (this.columnLabels == null) {
                    int cnt = this.stmt.getDataCount();
                    this.columnLabels = new String[cnt];
                    for (int i = 0; i < cnt; ++i) {
                        this.columnLabels[i] = this.stmt.getColumnLabel(i + 1);
                    }
                }
            } else {
                this.isFirst = false;
            }
            ++this.currentRow;
            return true;
        }
        if (ret == 101) {
            this.isAfterLast = true;
            this.isFirst = false;
            if (this.lastRow == -1) {
                this.lastRow = this.currentRow;
            }
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
            if (!(this.owner instanceof JdbcPreparedStatement)) {
                this.stmt.close();
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.validateResultSetOpen();
        return this.stmt.getString(this.lastColumnReadIndex) != null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        return this.stmt.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        return this.stmt.getInt(columnIndex) != 0;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        return (byte)this.stmt.getInt(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        return (short)this.stmt.getInt(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        return this.stmt.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        return this.stmt.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        return (float)this.stmt.getDouble(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        return this.stmt.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        BigDecimal ret = null;
        String val = this.stmt.getString(columnIndex);
        if (val != null) {
            ret = new BigDecimal(val).setScale(scale);
        }
        return ret;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        return this.stmt.getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        String val = this.stmt.getString(columnIndex);
        Date ret = null;
        if (val != null) {
            ret = new Date(JdbcResultSet.parseDateTimeString("yyyy-MM-dd", val));
        }
        return ret;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        String val = this.stmt.getString(columnIndex);
        Time ret = null;
        if (val != null) {
            ret = new Time(JdbcResultSet.parseDateTimeString("HH:mm:ss", val));
        }
        return ret;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        String val = this.stmt.getString(columnIndex);
        Timestamp ret = null;
        if (val != null) {
            ret = new Timestamp(JdbcResultSet.parseDateTimeString("yyyy-MM-dd HH:mm:ss", val));
        }
        return ret;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int arg1) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.validateResultSetOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.validateResultSetOpen();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new JdbcResultSetMetaData(this.stmt);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        if (this.columnTypes == null) {
            int cnt = this.stmt.getColumnCount();
            this.columnTypes = new int[cnt];
            for (int i = 0; i < cnt; ++i) {
                this.columnTypes[i] = this.stmt.getColumnType(i + 1);
            }
        }
        int type = this.columnTypes[columnIndex - 1];
        Object ret = null;
        String val = null;
        switch (type) {
            case 1: {
                val = this.getString(columnIndex);
                if (val == null) break;
                ret = Integer.parseInt(val);
                break;
            }
            case 2: {
                val = this.getString(columnIndex);
                if (val == null) break;
                ret = Double.parseDouble(val);
                break;
            }
            case 3: {
                ret = this.getString(columnIndex);
                break;
            }
            case 4: {
                ret = this.getBlob(columnIndex);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new SQLException("Unknown column type '" + type + "'.");
            }
        }
        return ret;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (int i = 0; i < this.columnLabels.length; ++i) {
            if (!this.columnLabels[i].equalsIgnoreCase(columnLabel)) continue;
            return i + 1;
        }
        throw new SQLException("Not found column '" + columnLabel + "'.");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        this.lastColumnReadIndex = columnIndex;
        BigDecimal ret = null;
        String val = this.stmt.getString(columnIndex);
        if (val != null) {
            ret = new BigDecimal(val);
        }
        return ret;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.validateResultSetOpen();
        return this.isBeforeFirst;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.validateResultSetOpen();
        return this.isAfterLast;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.validateResultSetOpen();
        return this.isFirst;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.lastRow == -1) {
            int row = this.currentRow;
            this.afterLast();
            this.absolute(row);
        }
        return this.lastRow == this.currentRow;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.validateResultSetOpen();
        if (!this.isBeforeFirst) {
            this.stmt.reset();
            this.isBeforeFirst = true;
            this.isFirst = false;
            this.isAfterLast = false;
            this.currentRow = 0;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        while (this.next()) {
        }
    }

    @Override
    public boolean first() throws SQLException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws SQLException {
        if (this.lastRow == -1) {
            this.afterLast();
        }
        return this.absolute(this.lastRow);
    }

    @Override
    public int getRow() throws SQLException {
        this.validateResultSetOpen();
        return this.currentRow;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.validateResultSetOpen();
        boolean ret = false;
        if (row == 0) {
            this.beforeFirst();
        } else if (row > 0) {
            if (row < this.currentRow) {
                this.beforeFirst();
            }
            ret = true;
            while (this.currentRow < row && (ret = this.next())) {
            }
        } else {
            if (this.lastRow == -1) {
                this.afterLast();
            }
            if ((row = this.lastRow + (row + 1)) < 1) {
                this.beforeFirst();
            } else {
                ret = this.absolute(row);
            }
        }
        return ret;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.validateResultSetOpen();
        boolean ret = false;
        int row = this.currentRow + rows;
        if (row > 0) {
            ret = this.absolute(row);
        } else {
            this.beforeFirst();
        }
        return ret;
    }

    @Override
    public boolean previous() throws SQLException {
        this.validateResultSetOpen();
        if (this.isBeforeFirst) {
            return false;
        }
        if (this.isFirst) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(this.currentRow - 1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        JdbcResultSet.validateResultSetFetchDirection(direction);
        this.validateResultSetOpen();
        if (direction != 1000) {
            throw new SQLException("Not supported fetch direction.");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.validateResultSetOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.validateResultSetOpen();
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        this.validateResultSetOpen();
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.validateResultSetOpen();
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateByte(int columnIndex, byte arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateShort(int columnIndex, short arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateInt(int columnIndex, int arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateLong(int columnIndex, long arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateFloat(int columnIndex, float arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateDouble(int columnIndex, double arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateString(int columnIndex, String arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateDate(int columnIndex, Date arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateTime(int columnIndex, Time arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateObject(int columnIndex, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateObject(int columnIndex, Object arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateByte(String columnLabel, byte arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateShort(String columnLabel, short arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateInt(String columnLabel, int arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateLong(String columnLabel, long arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateFloat(String columnLabel, float arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateDouble(String columnLabel, double arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateString(String columnLabel, String arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateDate(String columnLabel, Date arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateTime(String columnLabel, Time arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateObject(String columnLabel, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateObject(String columnLabel, Object arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public java.sql.Statement getStatement() throws SQLException {
        this.validateResultSetOpen();
        return this.owner;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.validateResultSetOpen();
        if (this.blob != null) {
            this.blob.close();
        }
        this.blob = new JdbcBlob(this.stmt, columnIndex);
        return this.blob;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date val = this.getDate(columnIndex);
        Date ret = null;
        if (val != null) {
            Calendar calendar = (Calendar)cal.clone();
            calendar.setTime(ret);
            ret = new Date(calendar.getTime().getTime());
        }
        return ret;
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time val = this.getTime(columnIndex);
        Time ret = null;
        if (val != null) {
            Calendar calendar = (Calendar)cal.clone();
            calendar.setTime(ret);
            ret = new Time(calendar.getTime().getTime());
        }
        return ret;
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp val = this.getTimestamp(columnIndex);
        Timestamp ret = null;
        if (val != null) {
            Calendar calendar = (Calendar)cal.clone();
            calendar.setTime(ret);
            ret = new Timestamp(calendar.getTime().getTime());
        }
        return ret;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String val = this.getString(columnIndex);
        URL ret = null;
        if (val != null) {
            try {
                ret = new URL(val);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(JdbcResultSet.class.getName()).throwing(JdbcResultSet.class.getName(), "getURL(int)", ex);
                throw new SQLException(ex.getMessage());
            }
        }
        return ret;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public void updateRef(int columnIndex, Ref arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateRef(String columnLabel, Ref arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(int columnIndex, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateBlob(String columnLabel, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(int columnIndex, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateClob(String columnLabel, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateArray(int columnIndex, Array arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateArray(String columnLabel, Array arg1) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed || this.stmt.isClosed();
    }

    protected void validateResultSetOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet is already closed.");
        }
    }

    public static void validateResultSetType(int resultSetType) throws SQLException {
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw new SQLException("Not supported result set type.");
        }
    }

    public static void validateResultSetConcurrency(int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw new SQLException("Not supported result set concurrency.");
        }
    }

    public static void validateResultSetHoldability(int resultSetHoldability) throws SQLException {
        if (resultSetHoldability != 1) {
            throw new SQLException("Not supported result set holdability.");
        }
    }

    public static void validateResultSetFetchDirection(int direction) throws SQLException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new SQLException("Not supported fetch direction.");
        }
    }

    private static long parseDateTimeString(String pattern, String source) throws SQLException {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        formatter.setLenient(false);
        ParsePosition position = new ParsePosition(0);
        java.util.Date date = formatter.parse(source, position);
        if (position.getErrorIndex() != -1 || position.getIndex() != source.length()) {
            throw new SQLException("Format error.");
        }
        return date.getTime();
    }
}

