/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sqlite.Database;
import org.sqlite.Driver;
import org.sqlite.TableInfo;
import org.sqlite.jdbc.JdbcPreparedStatement;
import org.sqlite.jdbc.JdbcResultSetMetaData;
import org.sqlite.jdbc.JdbcStatement;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SQLite3ColumnMetaData;
import org.sqlite.swig.SQLite3Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDatabaseMetaData
implements DatabaseMetaData {
    private final Database db;
    private final Connection conn;
    private final String url;

    JdbcDatabaseMetaData(Database db, Connection conn, String url) {
        this.db = db;
        this.conn = conn;
        this.url = url;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.url;
    }

    @Override
    public String getUserName() throws SQLException {
        return null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.db.getProductName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return SQLite3.getSqlite3_version();
    }

    @Override
    public String getDriverName() throws SQLException {
        return Driver.getDriverName();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return Driver.getDriverVersion();
    }

    @Override
    public int getDriverMajorVersion() {
        return Driver.getDriverMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return Driver.getDriverMinorVersion();
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return this.db.isInMemoryMode();
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "date,time,datetime,julianday,strftime";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return null;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return null;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return null;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 8;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String sql = "SELECT   NULL AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM, NULL AS PROCEDURE_NAME, NULL AS RESERVED_4, NULL AS RESERVED_5, NULL AS RESERVED_6, NULL AS REMARKS, NULL AS SPECIFIC_NAME LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM, NULL AS PROCEDURE_NAME, NULL AS RESERVED_4, NULL AS RESERVED_5, NULL AS RESERVED_6, NULL AS REMARKS, NULL AS SPECIFIC_NAME LIMIT 0");
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String sql = "SELECT   NULL AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM, NULL AS PROCEDURE_NAME, NULL AS COLUMN_NAME, NULL AS COLUMN_TYPE, NULL AS DATA_TYPE, NULL AS TYPE_NAME, NULL AS PRECISION, NULL AS LENGTH, NULL AS SCALE, NULL AS RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, NULL AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SPECIFIC_NAME LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM, NULL AS PROCEDURE_NAME, NULL AS COLUMN_NAME, NULL AS COLUMN_TYPE, NULL AS DATA_TYPE, NULL AS TYPE_NAME, NULL AS PRECISION, NULL AS LENGTH, NULL AS SCALE, NULL AS RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, NULL AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SPECIFIC_NAME LIMIT 0");
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String sqlTemplate = "SELECT  NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, name AS TABLE_NAME, upper(type) AS TABLE_TYPE, NULL AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION, sql AS SQL FROM sqlite_master WHERE (?1 IS NULL OR name LIKE ?1) AND (type IN ({0})) UNION ALL SELECT  NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, name AS TABLE_NAME, upper(type) AS TABLE_TYPE, NULL AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION, sql AS SQL FROM sqlite_temp_master WHERE (?1 IS NULL OR name LIKE ?1) AND (type IN ({0})) ORDER BY TABLE_TYPE, TABLE_NAME";
        if (types == null || types.length == 0) {
            types = new String[]{"table", "view"};
        }
        int typesSize = types.length;
        StringBuilder paramTypes = new StringBuilder();
        for (int i = 0; i < typesSize; ++i) {
            paramTypes.append("?").append(i + 2).append(",");
        }
        int last = paramTypes.length();
        paramTypes.delete(last - 1, last);
        Object[] arguments = new Object[]{paramTypes.toString()};
        String sql = new MessageFormat("SELECT  NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, name AS TABLE_NAME, upper(type) AS TABLE_TYPE, NULL AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION, sql AS SQL FROM sqlite_master WHERE (?1 IS NULL OR name LIKE ?1) AND (type IN ({0})) UNION ALL SELECT  NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, name AS TABLE_NAME, upper(type) AS TABLE_TYPE, NULL AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION, sql AS SQL FROM sqlite_temp_master WHERE (?1 IS NULL OR name LIKE ?1) AND (type IN ({0})) ORDER BY TABLE_TYPE, TABLE_NAME").format(arguments);
        JdbcPreparedStatement pstmt = (JdbcPreparedStatement)this.conn.prepareStatement(sql);
        int parameterIndex = 1;
        pstmt.setString(parameterIndex++, tableNamePattern);
        for (String type : types) {
            pstmt.setString(parameterIndex++, type.toLowerCase());
        }
        ResultSet rs = pstmt.executeQuery();
        pstmt.close(rs);
        return rs;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String sql = "SELECT NULL AS TABLE_SCHEM, NULL AS TABLE_CATALOG LIMIT 0";
        return this.produceDetachedResultSet("SELECT NULL AS TABLE_SCHEM, NULL AS TABLE_CATALOG LIMIT 0");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String sql = "SELECT NULL AS TABLE_CAT LIMIT 0";
        return this.produceDetachedResultSet("SELECT NULL AS TABLE_CAT LIMIT 0");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String sql = "SELECT 'TABLE' AS TABLE_TYPE UNION ALL SELECT 'VIEW' AS TABLE_TYPE";
        return this.produceDetachedResultSet("SELECT 'TABLE' AS TABLE_TYPE UNION ALL SELECT 'VIEW' AS TABLE_TYPE");
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String sql = "SELECT name FROM sqlite_master WHERE (?1 IS NULL OR name LIKE ?1) UNION ALL SELECT name FROM sqlite_temp_master WHERE (?1 IS NULL OR name LIKE ?1)";
        JdbcPreparedStatement pstmt = (JdbcPreparedStatement)this.conn.prepareStatement(sql);
        pstmt.setString(1, tableNamePattern);
        ResultSet rs = pstmt.executeQuery();
        if (!rs.next()) {
            rs.close();
            pstmt.close();
            sql = "SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS COLUMN_NAME, NULL AS DATA_TYPE, NULL AS TYPE_NAME, NULL AS COLUMN_SIZE, NULL AS BUFFER_LENGTH, NULL AS DECIMAL_DIGITS, NULL AS NUM_PREC_RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, NULL AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SCOPE_CATLOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE, NULL AS IS_AUTOINCREMENT LIMIT 0";
            return this.produceDetachedResultSet(sql);
        }
        Statement stmt = this.conn.createStatement();
        StringBuilder inlineView = new StringBuilder();
        do {
            String tableName = rs.getString(1);
            List<TableInfo> tblInf = this.getTableInfo(tableName);
            ResultSet rsTbl = stmt.executeQuery("SELECT * FROM " + tableName + " LIMIT 1");
            boolean hasRecord = rsTbl.next();
            JdbcResultSetMetaData rsMeta = (JdbcResultSetMetaData)rsTbl.getMetaData();
            for (int i = 0; i < rsMeta.getColumnCount(); ++i) {
                int col = i + 1;
                String columnName = rsMeta.getColumnName(col);
                TableInfo inf = JdbcDatabaseMetaData.searchTableInfo(tblInf, columnName);
                int columnType = rsMeta.getSQLiteColumnType(col);
                int dataType = columnType != 0 ? JdbcDatabaseMetaData.getColumnType(columnType) : 0;
                String typeName = rsMeta.getColumnTypeName(col);
                int precision = columnType != 0 ? JdbcDatabaseMetaData.getPrecision(columnType) : 0;
                int radix = columnType != 0 ? JdbcDatabaseMetaData.getRadix(columnType) : 0;
                SQLite3ColumnMetaData meta = this.db.getColumnMetaData(null, tableName, columnName);
                String defVal = null;
                if (inf.defaultValue != null) {
                    defVal = columnType == 1 && columnType == 2 ? inf.defaultValue : "'" + inf.defaultValue.replaceAll("'", "''") + "'";
                }
                boolean isNull = !meta.getNotNull();
                boolean isAutoInc = meta.getAutoIncrement();
                inlineView.append("SELECT ");
                inlineView.append("'").append(tableName).append("' AS TABLE_NAME");
                inlineView.append(", '").append(columnName).append("' AS COLUMN_NAME");
                inlineView.append(", ").append(dataType).append(" AS DATA_TYPE");
                inlineView.append(", '").append(typeName).append("' AS TYPE_NAME");
                inlineView.append(", ").append(precision != 0 ? String.valueOf(precision) : "NULL").append(" AS COLUMN_SIZE");
                inlineView.append(", ").append(radix != 0 ? String.valueOf(radix) : "NULL").append(" AS NUM_PREC_RADIX");
                inlineView.append(", ").append(isNull ? 1 : 0).append(" AS NULLABLE");
                inlineView.append(", ").append(defVal).append(" AS COLUMN_DEF");
                inlineView.append(", ").append(inf.columnIndex + 1).append(" AS ORDINAL_POSITION");
                inlineView.append(", '").append(isNull ? "YES" : "NO").append("' AS IS_NULLABLE");
                inlineView.append(", '").append(isAutoInc ? "YES" : "NO").append("' AS IS_AUTOINCREMENT");
                inlineView.append(" UNION ALL ");
            }
            rsTbl.close();
        } while (rs.next());
        rs.close();
        pstmt.close();
        sql = "SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, DATA_TYPE, TYPE_NAME, COLUMN_SIZE, NULL AS BUFFER_LENGTH, NULL AS DECIMAL_DIGITS, NUM_PREC_RADIX, NULLABLE, NULL AS REMARKS, COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, ORDINAL_POSITION, IS_NULLABLE, NULL AS SCOPE_CATLOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE, IS_AUTOINCREMENT FROM (" + inlineView.substring(0, inlineView.length() - 11) + ")" + " WHERE (?1 IS NULL OR COLUMN_NAME LIKE ?1)" + " ORDER BY TABLE_NAME, ORDINAL_POSITION";
        pstmt = (JdbcPreparedStatement)this.conn.prepareStatement(sql);
        pstmt.setString(1, columnNamePattern);
        rs = pstmt.executeQuery();
        pstmt.close(rs);
        return rs;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        String sql = "SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS COLUMN_NAME, NULL AS GRANTOR, NULL AS GRANTEE, NULL AS PRIVILEGE, NULL AS IS_GRANTABLE LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS COLUMN_NAME, NULL AS GRANTOR, NULL AS GRANTEE, NULL AS PRIVILEGE, NULL AS IS_GRANTABLE LIMIT 0");
    }

    @Override
    public ResultSet getTablePrivileges(String arg0, String arg1, String arg2) throws SQLException {
        String sql = "SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS GRANTOR, NULL AS GRANTEE, NULL AS PRIVILEGE, NULL AS IS_GRANTABLE LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS GRANTOR, NULL AS GRANTEE, NULL AS PRIVILEGE, NULL AS IS_GRANTABLE LIMIT 0");
    }

    @Override
    public ResultSet getBestRowIdentifier(String arg0, String arg1, String arg2, int arg3, boolean arg4) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public ResultSet getPrimaryKeys(String arg0, String arg1, String arg2) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public ResultSet getImportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public ResultSet getExportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        String sql = "SELECT   NULL AS PKTABLE_CAT, NULL AS PKTABLE_SCHEM, NULL AS PKTABLE_NAME, NULL AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT, NULL AS FKTABLE_SCHEM, NULL AS FKTABLE_NAME, NULL AS FKCOLUMN_NAME, NULL AS KEY_SEQ, NULL AS UPDATE_RULE, NULL AS DELETE_RULE, NULL AS FK_NAME, NULL AS PK_NAME, NULL AS DEFERRABILITY LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS PKTABLE_CAT, NULL AS PKTABLE_SCHEM, NULL AS PKTABLE_NAME, NULL AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT, NULL AS FKTABLE_SCHEM, NULL AS FKTABLE_NAME, NULL AS FKCOLUMN_NAME, NULL AS KEY_SEQ, NULL AS UPDATE_RULE, NULL AS DELETE_RULE, NULL AS FK_NAME, NULL AS PK_NAME, NULL AS DEFERRABILITY LIMIT 0");
    }

    @Override
    public ResultSet getCrossReference(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        String sql = "SELECT   TYPE_NAME, DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, NULL AS CREATE_PARAMS, 1 AS NULLABLE, CASE_SENSITIVE, 3 AS SEARCHABLE, UNSIGNED_ATTRIBUTE, 0 AS FIXED_PREC_SCALE, AUTO_INCREMENT, TYPE_NAME AS LOCAL_TYPE_NAME, 0 AS MINIMUM_SCALE, 0 AS MAXIMUM_SCALE, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NUM_PREC_RADIX FROM (SELECT  'NULL' AS TYPE_NAME, 0 AS DATA_TYPE, NULL AS PRECISION, NULL AS LITERAL_PREFIX, NULL AS LITERAL_SUFFIX, 0 AS CASE_SENSITIVE, 0 AS UNSIGNED_ATTRIBUTE, 0 AS AUTO_INCREMENT, NULL AS NUM_PREC_RADIX UNION ALL SELECT  'INTEGER' AS TYPE_NAME, 4 AS DATA_TYPE, " + JdbcDatabaseMetaData.getPrecision(1) + " AS PRECISION" + ", NULL AS LITERAL_PREFIX" + ", NULL AS LITERAL_SUFFIX" + ", 0 AS CASE_SENSITIVE" + ", 1 AS UNSIGNED_ATTRIBUTE" + ", 0 AS AUTO_INCREMENT" + ", 10 AS NUM_PREC_RADIX" + " UNION ALL " + "SELECT" + "  'REAL' AS TYPE_NAME" + ", " + 7 + " AS DATA_TYPE" + ", " + JdbcDatabaseMetaData.getPrecision(2) + " AS PRECISION" + ", NULL AS LITERAL_PREFIX" + ", NULL AS LITERAL_SUFFIX" + ", 0 AS CASE_SENSITIVE" + ", 1 AS UNSIGNED_ATTRIBUTE" + ", 0 AS AUTO_INCREMENT" + ", 10 AS NUM_PREC_RADIX" + " UNION ALL " + "SELECT" + "  'TEXT' AS TYPE_NAME" + ", " + 12 + " AS DATA_TYPE" + ", NULL AS PRECISION" + ", '''' AS LITERAL_PREFIX" + ", '''' AS LITERAL_SUFFIX" + ", 1 AS CASE_SENSITIVE" + ", 0 AS UNSIGNED_ATTRIBUTE" + ", 0 AS AUTO_INCREMENT" + ", NULL AS NUM_PREC_RADIX" + " UNION ALL " + "SELECT" + "  'BLOB' AS TYPE_NAME" + ", " + 2004 + " AS DATA_TYPE" + ", NULL AS PRECISION" + ", 'X''' AS LITERAL_PREFIX" + ", '''' AS LITERAL_SUFFIX" + ", 0 AS CASE_SENSITIVE" + ", 0 AS UNSIGNED_ATTRIBUTE" + ", 0 AS AUTO_INCREMENT" + ", NULL AS NUM_PREC_RADIX" + ") AS TYPE_INFO" + " ORDER BY TYPE_NAME";
        return this.produceDetachedResultSet(sql);
    }

    @Override
    public ResultSet getIndexInfo(String arg0, String arg1, String arg2, boolean arg3, boolean arg4) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int arg0) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String sql = "SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS CLASS_NAME, NULL AS DATA_TYPE, NULL AS REMARKS, NULL AS BASE_TYPE LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS CLASS_NAME, NULL AS DATA_TYPE, NULL AS REMARKS, NULL AS BASE_TYPE LIMIT 0");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        String sql = "SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SUPERTYPE_CAT, NULL AS SUPERTYPE_SCHEM, NULL AS SUPERTYPE_NAME LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SUPERTYPE_CAT, NULL AS SUPERTYPE_SCHEM, NULL AS SUPERTYPE_NAME LIMIT 0");
    }

    @Override
    public ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        String sql = "SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS SUPERTABLE_NAME LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS SUPERTABLE_NAME LIMIT 0");
    }

    @Override
    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        String sql = "SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS ATTR_NAME, NULL AS DATA_TYPE, NULL AS ATTR_TYPE_NAME, NULL AS ATTR_SIZE, NULL AS DECIMAL_DIGITS, NULL AS NUM_PREC_RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS ATTR_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, NULL AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SCOPE_CATALOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS ATTR_NAME, NULL AS DATA_TYPE, NULL AS ATTR_TYPE_NAME, NULL AS ATTR_SIZE, NULL AS DECIMAL_DIGITS, NULL AS NUM_PREC_RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS ATTR_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, NULL AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SCOPE_CATALOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE LIMIT 0");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return SQLite3Constants.SQLITE_VERSION_NUMBER / 1000000;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return SQLite3Constants.SQLITE_VERSION_NUMBER % 1000000 / 1000;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    private ResultSet produceDetachedResultSet(String sql) throws SQLException {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        ((JdbcStatement)stmt).detach(rs);
        stmt.close();
        return rs;
    }

    private List<TableInfo> getTableInfo(String tableName) throws SQLException {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("PRAGMA table_info(" + tableName + ")");
        ArrayList<TableInfo> ret = new ArrayList<TableInfo>();
        while (rs.next()) {
            ret.add(new TableInfo(rs.getInt(1), rs.getString(2), rs.getString(3), rs.getInt(4), rs.getString(5), rs.getInt(6)));
        }
        rs.close();
        stmt.close();
        return Collections.unmodifiableList(ret);
    }

    private static TableInfo searchTableInfo(List<TableInfo> tblInf, String columnName) {
        for (TableInfo inf : tblInf) {
            if (!inf.columnName.equalsIgnoreCase(columnName)) continue;
            return inf;
        }
        return null;
    }

    public static int getColumnType(int columnType) throws SQLException {
        switch (columnType) {
            case 1: {
                return 4;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 2004;
            }
            case 5: {
                return 0;
            }
        }
        throw new SQLException("Unknown column type '" + columnType + "'.");
    }

    public static String getColumnClassName(int columnType) throws SQLException {
        switch (columnType) {
            case 1: {
                return Integer.class.getName();
            }
            case 2: {
                return Double.class.getName();
            }
            case 3: {
                return String.class.getName();
            }
            case 4: {
                return Blob.class.getName();
            }
            case 5: {
                return Object.class.getName();
            }
        }
        throw new SQLException("Unknown column type '" + columnType + "'.");
    }

    public static int getPrecision(int columnType) {
        switch (columnType) {
            case 1: {
                return 10;
            }
            case 2: {
                return 16;
            }
        }
        return 0;
    }

    public static int getScale(int columnType) throws SQLException {
        switch (columnType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 0;
            }
        }
        throw new SQLException("Unknown column type '" + columnType + "'.");
    }

    public static int getColumnDisplaySize(int columnType) throws SQLException {
        switch (columnType) {
            case 1: {
                return 11;
            }
            case 2: {
                return 23;
            }
            case 3: 
            case 4: {
                return Integer.MAX_VALUE;
            }
            case 5: {
                return 0;
            }
        }
        throw new SQLException("Unknown column type '" + columnType + "'.");
    }

    public static boolean isSigned(int columnType) throws SQLException {
        switch (columnType) {
            case 1: 
            case 2: {
                return true;
            }
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw new SQLException("Unknown column type '" + columnType + "'.");
    }

    public static int getRadix(int columnType) throws SQLException {
        switch (columnType) {
            case 1: 
            case 2: {
                return 10;
            }
            case 3: 
            case 4: 
            case 5: {
                return 0;
            }
        }
        throw new SQLException("Unknown column type '" + columnType + "'.");
    }
}

