/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.sqlite.Database;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.jdbc.Scheme;

public class Driver
implements java.sql.Driver {
    public static String getDriverName() {
        return "SQLite JDBC Driver";
    }

    public static String getDriverVersion() {
        return Driver.getDriverMajorVersion() + "." + Driver.getDriverMinorVersion() + "." + Driver.getDriverReleaseVersion();
    }

    public static int getDriverMajorVersion() {
        return 0;
    }

    public static int getDriverMinorVersion() {
        return 0;
    }

    public static int getDriverReleaseVersion() {
        return 2;
    }

    public boolean acceptsURL(String url) {
        for (Scheme scheme : Scheme.values()) {
            if (!scheme.matches(url)) continue;
            return true;
        }
        return false;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        for (Scheme scheme : Scheme.values()) {
            Properties prop = scheme.parse(url);
            if (prop == null) continue;
            String filename = (String)prop.remove(";filename;");
            if (info != null) {
                prop.putAll((Map<?, ?>)info);
            }
            Database db = new Database(filename, prop);
            return new JdbcConnection(db, url);
        }
        return null;
    }

    public int getMajorVersion() {
        return Driver.getDriverMajorVersion();
    }

    public int getMinorVersion() {
        return Driver.getDriverMinorVersion();
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[]{new DriverPropertyInfo("OPEN_MODE", "READWRITE"), new DriverPropertyInfo("TRANSACTION_TYPE", "DEFERRED"), new DriverPropertyInfo("ENCODING", "UTF-8"), new DriverPropertyInfo("BUSY_TIMEOUT", "0"), new DriverPropertyInfo("CACHE_SIZE", "2000"), new DriverPropertyInfo("DEFAULT_CACHE_SIZE", "2000"), new DriverPropertyInfo("PAGE_SIZE", "1024"), new DriverPropertyInfo("MAX_PAGE_COUNT", "1073741823")};
    }

    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            System.loadLibrary("sqlite3jni");
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException ex) {
            Logger.getLogger(Driver.class.getName()).throwing(Driver.class.getName(), "<clinit>", ex);
            throw new Error(ex.fillInStackTrace());
        }
    }
}

