/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.sqlite.Statement;
import org.sqlite.TransactionType;
import org.sqlite.jdbc.JdbcSQLException;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SQLite3ColumnMetaData;
import org.sqlite.swig.SWIGTYPE_p_p_sqlite3;
import org.sqlite.swig.SWIGTYPE_p_sqlite3;
import org.sqlite.types.SQLite3Handle;
import org.sqlite.types.SQLite3StmtPtrPtr;

public class Database {
    private final SQLite3Handle handle = new SQLite3Handle();
    private Map<Long, Statement> statements;
    protected final Properties info;
    private final boolean isInMemory;
    private int timeout;

    public Database(String filename, Properties info) throws SQLException {
        this.info = info;
        this.isInMemory = filename == null || SQLite3.getInMemoryFileName().equals(filename);
        this.open(filename);
    }

    public String getProductName() {
        return "SQLite";
    }

    public boolean isInMemoryMode() {
        return this.isInMemory;
    }

    private void open(String filename) throws SQLException {
        SWIGTYPE_p_p_sqlite3 ppDb = this.handle.getSQLite3PtrPtr();
        int ret = SQLite3.sqlite3_open(filename, ppDb);
        if (ret != 0) {
            SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
            JdbcSQLException ex = new JdbcSQLException(db);
            this.handle.delete();
            throw ex;
        }
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isClosed() {
        return this.handle.isDeleted();
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.closeStatements();
            SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
            int ret = SQLite3.sqlite3_close(db);
            if (ret != 0) {
                throw new JdbcSQLException(db);
            }
            this.handle.delete();
        }
    }

    public boolean getAutoCommit() {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        return SQLite3.sqlite3_get_autocommit(db) != 0;
    }

    public int setBusyTimeout(int ms) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        int ret = SQLite3.sqlite3_busy_timeout(db, ms);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        this.timeout = ms < 1 ? 0 : ms;
        return ret;
    }

    public int getBusyTimeout() {
        return this.timeout;
    }

    public int execute(String sql) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        int ret = 0;
        if (this.timeout == 0) {
            while ((ret = SQLite3.sqlite3_exec(db, sql)) == 5) {
            }
        } else {
            ret = SQLite3.sqlite3_exec(db, sql);
            if (ret == 5) {
                throw new SQLException("Timeout expired.");
            }
        }
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        return ret;
    }

    public void pragma(String[] commands) throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        for (String cmd : commands) {
            int ret = SQLite3.sqlite3_exec(db, "PRAGMA " + cmd);
            if (ret == 0) continue;
            throw new JdbcSQLException(db);
        }
    }

    public void beginTransaction(TransactionType type) throws SQLException {
        this.closeStatements();
        if (type == null) {
            this.execute("BEGIN");
        } else {
            this.execute("BEGIN " + (Object)((Object)type));
        }
    }

    public void commitTransaction() throws SQLException {
        this.closeStatements();
        this.execute("COMMIT");
    }

    public void rollbackTransaction() throws SQLException {
        this.closeStatements();
        this.execute("ROLLBACK");
    }

    public Statement prepare(String sql, SQLite3StmtPtrPtr ppStmt) throws SQLException {
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        if (ppStmt == null) {
            throw new NullPointerException("ppStmt is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt, null);
        if (ret != 0) {
            throw new JdbcSQLException(db);
        }
        return new Statement(this, ppStmt.getSQLite3StmtPtr());
    }

    public Statement prepare(String sql) throws SQLException {
        SQLite3StmtPtrPtr ppStmt;
        if (sql == null) {
            throw new NullPointerException("sql is null.");
        }
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        int ret = SQLite3.sqlite3_prepare(db, sql, -1, ppStmt = new SQLite3StmtPtrPtr(), null);
        if (ret != 0) {
            ppStmt.delete();
            throw new JdbcSQLException(db);
        }
        return new Statement(this, ppStmt);
    }

    public void interrupt() throws SQLException {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        SQLite3.sqlite3_interrupt(db);
        this.closeStatements();
    }

    public int changes() {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        return SQLite3.sqlite3_changes(db);
    }

    public int totalChanges() {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        return SQLite3.sqlite3_total_changes(db);
    }

    public long lastInsertRowId() {
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        return SQLite3.sqlite3_last_insert_rowid(db);
    }

    public SQLite3ColumnMetaData getColumnMetaData(String dbName, String tableName, String columnName) throws SQLException {
        SQLite3ColumnMetaData meta;
        SWIGTYPE_p_sqlite3 db = this.handle.getInstance();
        int ret = SQLite3.sqlite3_table_column_metadata_by_struct(db, dbName, tableName, columnName, meta = new SQLite3ColumnMetaData());
        if (ret != 0) {
            meta.delete();
            throw new JdbcSQLException(db);
        }
        return meta;
    }

    void addStatement(Statement stmt) throws SQLException {
        long key;
        if (this.statements == null) {
            this.statements = new HashMap<Long, Statement>();
        }
        if (this.statements.containsKey(key = stmt.getHandle())) {
            throw new SQLException("Duplicate sqlite3_stmt handle error.");
        }
        this.statements.put(key, stmt);
    }

    void removeStatement(Statement stmt) throws SQLException {
        long key = stmt.getHandle();
        if (this.statements == null || this.statements.remove(key) == null) {
            throw new SQLException("Unmanaged sqlite3_stmt handle error.");
        }
    }

    private void closeStatements() throws SQLException {
        if (this.statements != null) {
            for (Statement stmt : this.statements.values()) {
                stmt.closeForced();
            }
            this.statements = null;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            Logger.getLogger("global").severe("Database connection has leaked!");
        }
        super.finalize();
    }
}

