/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Scheme {
    JDBC_SQLITE_FILE("jdbc:sqlite:file:"),
    JDBC_SQLITE_MEMORY("jdbc:sqlite:mem:"){

        public String getFilename(String url) {
            if (this.matches(url)) {
                return ":memory:";
            }
            return null;
        }
    }
    ,
    JDBC_SQLITE("jdbc:sqlite:");

    private final String scheme;

    private Scheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean matches(String url) {
        return url.startsWith(this.scheme);
    }

    public String getFilename(String url) {
        if (this.matches(url)) {
            return url.substring(this.scheme.length());
        }
        return null;
    }

    public Properties getOptions(String url) {
        return null;
    }

    public String toString() {
        return this.scheme;
    }
}

